package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.web.action.UtilAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

/**
 * @author chemit
 */
public class TransporteurForm extends AbstractRefForm<Transporteur> {

    private static final long serialVersionUID = 1L;

    protected String name;
    protected String societeId;

    public String getName() {
        return name;
    }

    public String getSocieteId() {
        return societeId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSocieteId(String societeId) {
        this.societeId = societeId;
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        topiaId = null;
        code = null;
        name = null;
        societeId = null;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "code", "error.transporteur.code.required");
        UtilAction.checkRequiredField(request, errors, "name", "error.transporteur.name.required");
        UtilAction.checkRequiredField(request, errors, "societeId", "error.transporteur.societeId.required");

        return errors;
    }

    public void fromBean(Transporteur bean) {
        setTopiaId(bean.getTopiaId());
        setCode(bean.getCode());
        setName(bean.getName());
        setSocieteId(bean.getSociete().getTopiaId());
    }

    public Transporteur toBean() {
        Transporteur bean = new com.cybelia.sandra.entities.TransporteurImpl();
        bean.setTopiaId(getTopiaId());
        bean.setCode(getCode());
        bean.setName(getName());
        Societe societe = new com.cybelia.sandra.entities.SocieteImpl();
        societe.setTopiaId(getSocieteId());
        bean.setSociete(societe);
        return bean;
    }

}
