package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuiton.topia.TopiaException;

/**
 * Classe pour gerer les {@link  Transporteur}.
 *
 * @author chemit
 */
public class TransporteurAction extends AbstractRefAction<Transporteur, TransporteurForm> {

    public TransporteurAction() {
        super(Transporteur.class, TransporteurPaginedListExtractor.class);
    }

    @Override
    protected PaginedListImpl<Transporteur> getPaginedList(String name, HttpServletRequest request, AbstractRefPaginedListExtractor<Transporteur> extractor) {
        PaginedListImpl<Transporteur> paginedList = super.getPaginedList(name, request, extractor);
        paginedList.setSortCriterion("name");
        return paginedList;
    }

    public static class TransporteurPaginedListExtractor extends AbstractRefPaginedListExtractor<Transporteur> {

        private static final long serialVersionUID = 3818166383606197935L;

        public TransporteurPaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        public Transporteur getBean(String topiaId) throws LogicException, TopiaException {
            return service.getTransporteur(null, topiaId);
        }

        protected Transporteur saveBean(Transporteur bean) throws LogicException, TopiaException {
            return service.saveTransporteur(null, bean);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return Cache.Transporteur.size(ApplicationSession.get(request));
        }

        public List<Transporteur> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception {
            return service.getTransporteurs(null, startIndex, endIndex, sortCriterion, sortDirection);
        }
    }

}
