package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.web.action.UtilAction;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

/**
 * @author chemit
 */
public class SocieteForm extends AbstractRefForm<Societe> {

    private static final long serialVersionUID = 1L;

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        topiaId = code = null;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "code", "error.societe.code.required");

        return errors;
    }

    public void fromBean(Societe bean) {
        setTopiaId(bean.getTopiaId());
        setCode(bean.getCode());
    }

    public Societe toBean() {
        Societe bean = new com.cybelia.sandra.entities.SocieteImpl();
        bean.setTopiaId(getTopiaId());
        bean.setCode(getCode());
        return bean;
    }

}
