package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.nuiton.topia.TopiaException;

/**
 * Classe pour gerer les {@link Societe}.
 *
 * @author chemit
 */
public class SocieteAction extends AbstractRefAction<Societe, SocieteForm> {


    public SocieteAction() {
        super(Societe.class, SocietePaginedListExtractor.class);
    }

    @Override
    protected PaginedListImpl<Societe> getPaginedList(String name, HttpServletRequest request, AbstractRefPaginedListExtractor<Societe> extractor) {
        PaginedListImpl<Societe> paginedList = super.getPaginedList(name, request, extractor);
        paginedList.setSortCriterion("code");
        return paginedList;
    }

    public static class SocietePaginedListExtractor extends AbstractRefPaginedListExtractor<Societe> {

        private static final long serialVersionUID = 3818166383606197935L;

        public SocietePaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        public Societe getBean(String topiaId) throws LogicException, TopiaException {
            return service.getSociete(null, topiaId);
        }

        protected Societe saveBean(Societe bean) throws LogicException, TopiaException {
            return service.saveSociete(null, bean);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return Cache.Societe.size(ApplicationSession.get(request));
        }

        public List<Societe> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception {
            return service.getSocietes(null, startIndex, endIndex, sortCriterion, sortDirection);
        }
    }
}
