package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.Transporteur;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.UtilAction.BadInputException;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

/**
 * Le formulaire d'edition
 */
public class CamionForm extends AbstractRefForm<Camion> {

    private static final long serialVersionUID = 1L;

    protected String societeId;
    protected String transporteurId;
    protected String camionPrincipalId;

    protected Camion camionPrincipal;

    protected int nombreCompartiments;

    public String getSocieteId() {
        return societeId;
    }

    public int getNombreCompartiments() {
        return nombreCompartiments;
    }

    public String getTransporteurId() {
        return transporteurId;
    }

    public String getCamionPrincipalId() {
        return camionPrincipalId;
    }

    public Camion getCamionPrincipal() {
        return camionPrincipal;
    }

    public void setNombreCompartiments(int nombreCompartiments) {
        this.nombreCompartiments = nombreCompartiments;
    }

    public void setSocieteId(String societeId) {
        this.societeId = societeId;
    }

    public void setTransporteurId(String transporteurId) {
        this.transporteurId = transporteurId;
    }

    public void setCamionPrincipalId(String camionPrincipalId) {
        this.camionPrincipalId = camionPrincipalId;
    }

    public void setCamionPrincipal(Camion camionPrincipal) {
        this.camionPrincipal = camionPrincipal;
        if (camionPrincipal != null) {
            this.camionPrincipalId = camionPrincipal.getTopiaId();
        }
    }

    @Override
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        topiaId = code = societeId = transporteurId = camionPrincipalId = null;
        nombreCompartiments = 0;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "code", "error.camion.code.required");
        UtilAction.checkRequiredField(request, errors, "societeId", "error.camion.societeId.required");
        UtilAction.checkRequiredField(request, errors, "transporteurId", "error.camion.transporteurId.required");

        try {
            int nbCompartiments = UtilAction.getParameterInt(request, "nombreCompartiments");
            if (nbCompartiments <= 0) {
                errors.add("nombreCompartimentsPositif", new ActionMessage("error.camion.nombreCompartiments.syntax"));
            }
        } catch (BadInputException e) {
            errors.add("nombreCompartimentsSyntax", new ActionMessage("error.camion.nombreCompartiments.syntax"));
        }
        return errors;
    }

    public void fromBean(Camion bean) {
        setTopiaId(bean.getTopiaId());
        setCode(bean.getCode());
        setNombreCompartiments(bean.getNombreCompartiments());
        setSocieteId(bean.getSociete().getTopiaId());
        setTransporteurId(bean.getTransporteur().getTopiaId());
    }

    public Camion toBean() {
        Camion bean = new com.cybelia.sandra.entities.CamionImpl();
        bean.setTopiaId(getTopiaId());
        bean.setCode(getCode());
        bean.setNombreCompartiments(getNombreCompartiments());

        Societe societe = new com.cybelia.sandra.entities.SocieteImpl();
        societe.setTopiaId(getSocieteId());
        bean.setSociete(societe);

        Transporteur transporteur = new com.cybelia.sandra.entities.TransporteurImpl();
        transporteur.setTopiaId(getTransporteurId());
        bean.setTransporteur(transporteur);

        return bean;
    }
}
