package com.cybelia.sandra.web.action.ref;

import org.nuiton.topia.persistence.TopiaEntity;

/**
 * An abstract form for a ref bean object.
 *
 * @author chemit
 */
public abstract class AbstractRefForm<B extends TopiaEntity> extends org.apache.struts.action.ActionForm {

    private static final long serialVersionUID = 1L;

    protected String topiaId;
    protected String code;

    public String getTopiaId() {
        return topiaId;
    }

    public String getCode() {
        return code;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * Remplit le form a partir du bean
     *
     * @param bean le bean d'origine
     */
    public abstract void fromBean(B bean);

    /**
     * Remplit le bean a partir du form
     *
     * @return le bean de destination
     */
    public abstract B toBean();
}
