package com.cybelia.sandra.web.action.ref;

import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ApplicationSession;
import com.cybelia.sandra.web.action.CommonMappingDispatchAction;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.displaytag.AbstractPaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;

/**
 * @author chemit
 */
public abstract class AbstractRefAction<B extends TopiaEntity, F extends AbstractRefForm<B>> extends CommonMappingDispatchAction {

    protected final Class<B> beanClass;
    protected Constructor<? extends AbstractRefPaginedListExtractor<B>> extractorConstructor;

    protected AbstractRefAction(Class<B> beanClass, Class<? extends AbstractRefPaginedListExtractor<B>> extractorClass) {
        this.beanClass = beanClass;
        try {
            this.extractorConstructor = extractorClass.getConstructor(ServiceWeb.class);
        } catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServiceWeb serviceWeb = ServiceFactory.newServiceWeb();
        try {
            return new Object[]{mapping, form, request, response, serviceWeb, extractorConstructor.newInstance(serviceWeb)};
        } catch (Exception e) {
            throw new RuntimeException("could not instanciate extractor " + extractorConstructor
                    + " for reason " + e.getMessage(), e);
        }
    }

    @SuppressWarnings({"unchecked"})
    protected PaginedListImpl<B> getPaginedList(String name, HttpServletRequest request, AbstractRefPaginedListExtractor<B> extractor) {
        // creation de la liste paginee
        PaginedListImpl<B> list = new PaginedListImpl<B>(extractor);
        request.setAttribute(name, list);
        return list;
    }

    public ActionForward list(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb, AbstractRefPaginedListExtractor<B> extractor) throws Exception {

        PaginedListImpl<B> paginedList = getPaginedList("beans", request, extractor);
        // get beans from service
        List<B> beans = paginedList.fromRequest(request).acquireData(request).getList();
        if (log.isDebugEnabled()) {
            log.debug("retreave list from service " + (beans == null ? 0 : beans.size()));
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward view(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb, AbstractRefPaginedListExtractor<B> extractor) throws Exception {

        // get bean code if exists
        String topiaId = request.getParameter("topiaId");

        if (StringUtils.isNotBlank(topiaId)) {
            // retreave bean from service
            B camion = extractor.getBean(topiaId);
            if (log.isDebugEnabled()) {
                log.debug("retreave bean from service : " + camion);
            }
            // transfert bean to form
            getForm(form).fromBean(camion);
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request,
                              HttpServletResponse response, ServiceWeb serviceWeb,
                              AbstractRefPaginedListExtractor<B> extractor) throws Exception {

        // convert form to bean
        B bean = getForm(form).toBean();

        // save bean
        bean = extractor.saveBean(bean);
        if (log.isDebugEnabled()) {
            log.debug("saved " + bean);
        }

        // recompute cache
        ApplicationSession.get(request).clearNaming(beanClass);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    @SuppressWarnings({"unchecked"})
    protected F getForm(ActionForm form) {
        return (F) form;
    }

    public abstract static class AbstractRefPaginedListExtractor<B> extends AbstractPaginedListExtractor<B> {

        private static final long serialVersionUID = 1L;

        protected AbstractRefPaginedListExtractor(ServiceWeb service) {
            super(service);
        }

        protected abstract B saveBean(B bean) throws LogicException, TopiaException;
    }
}
