package com.cybelia.sandra.web.action.notifier;

import com.cybelia.sandra.entities.notifier.Cron;
import com.cybelia.sandra.entities.notifier.CronImpl;
import com.cybelia.sandra.entities.notifier.Event;
import com.cybelia.sandra.entities.notifier.EventImpl;
import com.cybelia.sandra.web.action.UtilAction;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class CronForm extends ActionForm {

    private static final long serialVersionUID = 1L;

    protected static final Log log = LogFactory.getLog(CronForm.class);

    protected String eventTopiaId;
    protected String authorTopiaId;
    protected String topiaId;
    protected String label;
    protected Date dateStart;
    protected Date dateEnd;
    protected String templateModel;
    protected String templateName;
    protected String templateContent;
    protected boolean enable;
    protected Collection<String> variables;

    protected String seconds;
    protected String minutes;
    protected String hours;
    protected String dayOfMonth;
    protected String month;
    protected String dayOfWeek;
    protected String year;

    public Date getDateEnd() {
        return dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public Date getDateStart() {
        return dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getEventTopiaId() {
        return eventTopiaId;
    }

    public void setEventTopiaId(String eventTopiaId) {
        this.eventTopiaId = eventTopiaId;
    }

    public String getAuthorTopiaId() {
        return authorTopiaId;
    }

    public void setAuthorTopiaId(String authorTopiaId) {
        this.authorTopiaId = authorTopiaId;
    }

    public String getAuthorName() {
        return authorTopiaId;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getTemplateContent() {
        return templateContent;
    }

    public void setTemplateContent(String templateContent) {
        this.templateContent = templateContent;
    }

    public Collection<String> getVariables() {
        return variables;
    }

    public void setVariables(Collection<String> variables) {
        this.variables = variables;
    }

    public String getTemplateModel() {
        return templateModel;
    }

    public void setTemplateModel(String templateModel) {
        this.templateModel = templateModel;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getDayOfWeek() {
        return dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getDayOfMonth() {
        return dayOfMonth;
    }

    public void setDayOfMonth(String dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public String getHours() {
        return hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getMinutes() {
        return minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public String getSeconds() {
        return seconds;
    }

    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping,
                                 HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField(request, errors, "label", "error.notifier.label.required");
        UtilAction.checkRequiredField(request, errors, "templateName", "error.notifier.templateName.required");
        UtilAction.checkRequiredField(request, errors, "eventTopiaId", "error.notifier.templateName.required");
        return errors;
    }

    public void fromBean(Cron cron, String templateContent) {
        setDateEnd(cron.getDateEnd());
        setDateStart(cron.getDateStart());
        setEnable(cron.getEnable());
        setEventTopiaId(cron.getEvent().getTopiaId());
        setAuthorTopiaId(cron.getAuthor());
        String expression = cron.getExpression();
        if (expression != null && !"".equals(expression)) {
            String[] split = expression.split(" ");
            setSeconds(split[0]);
            setMinutes(split[1]);
            setHours(split[2]);
            setDayOfMonth(split[3]);
            setMonth(split[4]);
            setDayOfWeek(split[5]);
            if (split.length == 7) {
                setYear(split[6]);
            }
        }
        setLabel(cron.getLabel());
        setTemplateModel(cron.getTemplate());
        setTemplateName(cron.getTemplate());
        setTopiaId(cron.getTopiaId());
        setTemplateContent(templateContent);
        setVariables(cron.getEvent().getVariables());
    }

    public Cron toBean() {
        Cron cron = new CronImpl();
        cron.setDateEnd(getDateEnd());
        cron.setDateStart(getDateStart());
        cron.setEnable(isEnable());
        Event event = new EventImpl();
        event.setTopiaId(getEventTopiaId());
        cron.setEvent(event);
        cron.setAuthor(authorTopiaId);
        cron.setExpression((getSeconds() + " " +
                getMinutes() + " " +
                getHours() + " " +
                getDayOfMonth() + " " +
                getMonth() + " " +
                getDayOfWeek() + " " +
                getYear()).trim());
        cron.setLabel(getLabel());
        cron.setTemplate(getTemplateName());
        cron.setTopiaId(getTopiaId());
        return cron;
    }
}
