package com.cybelia.sandra.web.action.loading.model;

import java.util.Calendar;
import java.util.Date;

/**
 * @author chemit
 */
public class Column {

    protected Calendar calendar;

    protected Day day;
    protected int hour;
    protected boolean firstHour;

    protected Chargement chargement;

    protected Date currentDate;

    public Day getDay() {
        return day;
    }

    public int getHour() {
        return hour;
    }

    public boolean isFirstHour() {
        return firstHour;
    }

    public Chargement getChargement() {
        return chargement;
    }

    public Date getCurrentDate() {
        return currentDate;
    }

    public void setDay(Day day) {
        this.day = day;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setFirstHour(boolean firstHour) {
        this.firstHour = firstHour;
    }

    public void setChargement(Chargement chargement) {
        this.chargement = chargement;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public Date getStartingDate() {
        Calendar cal = getCalendar();
        cal.setTime(day.getDay());
        cal.set(Calendar.HOUR_OF_DAY, hour);
        return cal.getTime();
    }

    public Date getEndingDate() {
        Calendar cal = getCalendar();
        cal.setTime(getStartingDate());
        cal.add(Calendar.HOUR_OF_DAY, 1);
        return cal.getTime();
    }

    protected Calendar getCalendar() {
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar;
    }
}
