package com.cybelia.sandra.web.action.loading;

import com.cybelia.sandra.entities.ChargementUsineConfig;
import com.cybelia.sandra.entities.StatutEnum;
import com.cybelia.sandra.web.action.ApplicationSession.Cache;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.loading.model.LoadingTable;
import com.cybelia.sandra.web.action.loading.model.ModelHelper;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/**
 * @author chemit
 */
public class ChargementUsineForm extends ActionForm {

    /**
     * l'id de l'usine concerne
     */
    protected String usineTopiaId;

    /**
     * La configuration pour l'usine
     */
    protected transient ChargementUsineConfig config;

    protected transient LoadingTable model;

    /**
     * la borne inferieure de la fenetre a afficher (sera recupere de l'ui)
     */
    protected Long startingDateAsLong;

    /**
     * la borne inferieure de la fenetre precedente (utilise pour afficher la fenetre precedente)
     */
    protected long previousStartingDateAsLong;

    /**
     * la borne superieure de la fenetre suivante (utilise pour le title de l'action 'precedent')
     */
    protected long previousEndingDateAsLong;

    /**
     * le borne inferieure de la fenetre suivante (utilise pour afficher la fenetre suivante)
     */
    protected long nextStartingDateAsLong;

    /**
     * la borne superieure de la fenetre suivante (utilise pour le title de l'action 'suivant')
     */
    protected long nextEndingDateAsLong;

    private static final long serialVersionUID = 1L;

    // les setter utilisables pour remonter les informations de l'ui

    public ChargementUsineForm() throws Exception {
        usineTopiaId = Cache.Usine.getDefaultEntry();
    }

    public void setUsineTopiaId(String usineTopiaId) {
        this.usineTopiaId = usineTopiaId;
    }

    public void setStartingDateAsLong(long startingDateAsLong) {
        this.startingDateAsLong = startingDateAsLong;
    }

    // les getter utilisables dans l'ui
    public StatutEnum[] getStatus() {
        return StatutEnum.values();
    }

    public String getUsineTopiaId() {
        return usineTopiaId;
    }

    public long getStartingDateAsLong() {
        return startingDateAsLong;
    }

    public long getPreviousStartingDateAsLong() {
        return previousStartingDateAsLong;
    }

    public long getNextStartingDateAsLong() {
        return nextStartingDateAsLong;
    }

    public Date getPreviousStartingDate() {
        return new Date(previousStartingDateAsLong);
    }

    public Date getPreviousEndingDate() {
        return new Date(previousEndingDateAsLong);
    }

    public Date getNextStartingDate() {
        return new Date(nextStartingDateAsLong);
    }

    public Date getNextEndingDate() {
        return new Date(nextEndingDateAsLong);
    }

    public ChargementUsineConfig getConfig() {
        return config;
    }

    public LoadingTable getModel() {
        return model;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {

        ActionErrors errors = new ActionErrors();
        UtilAction.checkRequiredField(request, errors, "usineTopiaId", "error.loading.usine.required");

        return errors;
    }

    public void fromBean(ChargementUsineConfig bean, LoadingTable model) throws Exception {

        if (bean != null) {
            config = bean;
            setUsineTopiaId(bean.getUsine().getTopiaId());
        }

        this.model = model;
        Date currentDate = model.getCurrentDate();

        Date startingDate, endingDate;
        if (startingDateAsLong == null || startingDateAsLong == 0) {
            // compute starting date from currentDate
            startingDate = ModelHelper.getStartingDateFromCurrentDate(currentDate, config.getNombreHeures(), config.getPositionHeureActuelle());
            startingDateAsLong = startingDate.getTime();
        } else {
            startingDate = new Date(startingDateAsLong);
        }

        int amount = config.getNombreHeures();
        // compute endingDate
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startingDate);
        calendar.add(Calendar.HOUR_OF_DAY, amount - 1);
        endingDate = calendar.getTime();

        // compute nextStartingDateAsLong (this is endingDate)
        nextStartingDateAsLong = endingDate.getTime();
        calendar.setTime(endingDate);
        calendar.add(Calendar.HOUR_OF_DAY, amount - 1);
        nextEndingDateAsLong = calendar.getTime().getTime();

        // compute previousStartingDateAsLong
        calendar.setTime(startingDate);
        calendar.add(Calendar.HOUR_OF_DAY, -amount + 1);
        previousStartingDateAsLong = calendar.getTime().getTime();

        model.init(startingDate, endingDate, config);
    }

}
