package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.NoteImpl;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.web.action.UtilAction;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

public class NoteForm extends ActionForm {

    private static final long serialVersionUID = 1L;

    protected String topiaId;
    protected String breederTopiaId;
    protected String nom;
    transient protected Eleveur breeder;

    protected String description;
    protected String contentType;
    transient protected FormFile file;
    protected boolean gps;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FormFile getFile() {
        return file;
    }

    public void setFile(FormFile file) {
        this.file = file;
    }

    public InputStream getInputStream() throws IOException {
        return file.getInputStream();
    }

    public Eleveur getBreeder() {
        return breeder;
    }

    public void setBreeder(Eleveur breeder) {
        this.breeder = breeder;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getNom() {
        return nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public boolean isGps() {
        return gps;
    }

    public void setGps(boolean gps) {
        this.gps = gps;
    }

    public String getBreederTopiaId() {
        return breederTopiaId;
    }

    public void setBreederTopiaId(String breederTopiaId) {
        this.breederTopiaId = breederTopiaId;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "breederTopiaId", "error.note.breeder.required");
        UtilAction.checkRequiredField(request, errors, "description", "error.note.description.required");
        UtilAction.checkRequiredField(request, errors, "filename", "error.note.file.required");

        return errors;
    }

    public void fromBean(Note bean) {
        setTopiaId(bean.getTopiaId());
        setNom(bean.getNom());
        setDescription(bean.getDescription());
        setContentType(bean.getContentType());
        if (bean.getEleveur() != null) {
            setBreeder(bean.getEleveur());
            setBreederTopiaId(getBreeder().getTopiaId());
            PointGPS pointGPS = getBreeder().getTomtomGPS();
            boolean gps = pointGPS != null && !(pointGPS.getPoint().getX() == 0 && pointGPS.getPoint().getY() == 0);
            setGps(gps);
        }
    }

    public void fromBean(Eleveur bean) {
        setTopiaId(null);
        setNom(null);
        setDescription(null);
        setContentType(null);
        setBreeder(bean);
        setBreederTopiaId(getBreeder().getTopiaId());
        PointGPS pointGPS = getBreeder().getTomtomGPS();
        boolean gps = pointGPS != null && !(pointGPS.getPoint().getX() == 0 && pointGPS.getPoint().getY() == 0);
        setGps(gps);
    }

    public Note toBean() {
        Note note = new NoteImpl();
        note.setTopiaId(getTopiaId());
        note.setNom(getFile().getFileName());
        note.setDescription(getDescription());
        note.setContentType(getFile().getContentType());
        return note;
    }
}
