package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceHelper;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.action.UtilAction;
import com.cybelia.sandra.web.action.UtilAction.BadInputException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.taas.entities.TaasUser;

/**
 * @author letellier
 */
public class InfoAccessAction extends com.cybelia.sandra.web.action.CommonMappingDispatchAction {

    protected String cachedEleveurTopiaId = null;
    protected Eleveur cachedEleveur = null;

    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, response, ServiceFactory.newServiceWeb()};
    }

    public ActionForward list(ActionMapping mapping, ActionForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {

        log.info("InfoAccessAction list whith topiaId : " + request.getAttribute("breederTopiaId"));

        String topiaId = (String) request.getAttribute("breederTopiaId");
        if (StringUtils.isNotBlank(topiaId)) {
            cachedEleveurTopiaId = topiaId;
            cachedEleveur = serviceWeb.getEleveur(null, topiaId);
            List<InfoAccess> infoAccess = new ArrayList<InfoAccess>();
            for (InfoAccess silo : cachedEleveur.getActiveAccesSilo()) {
                if (silo != null) {
                    infoAccess.add(silo);
                }
            }
            request.setAttribute("accesSilos", infoAccess);
        }

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward view(ActionMapping mapping, InfoAccessForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {

        if (UtilAction.isNotEmptyParameter(request, "breederTopiaId")) {
            String breederTopiaId = UtilAction.getParameterString(request, "breederTopiaId");
            form.setEleveurTopiaId(breederTopiaId);
            cachedEleveurTopiaId = breederTopiaId;
        }
        if (UtilAction.isNotEmptyParameter(request, "topiaId")) {
            String topiaId = UtilAction.getParameterString(request, "topiaId");
            InfoAccess infoAccess = serviceWeb.getInfoAccess(null, topiaId);
            if (infoAccess == null) {
                log.error("Cant display infoAccess : " + topiaId);
            } else {
                form.fromBean(infoAccess);
            }
        }
        chargeEleveur(request, form, serviceWeb);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward delete(ActionMapping mapping, InfoAccessForm form,
                                HttpServletRequest request, HttpServletResponse response,
                                ServiceWeb serviceWeb) throws Exception {

        String topiaId = UtilAction.getParameterString(request, "topiaId");

        serviceWeb.deleteAccesSilo(null, topiaId);

        // force to reload eleveur
        cachedEleveur = null;
        chargeEleveur(request, form, serviceWeb);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward lockInfoAccess(ActionMapping mapping, InfoAccessForm form,
                                        HttpServletRequest request, HttpServletResponse response,
                                        ServiceWeb serviceWeb) throws Exception {

        String topiaId = topiaId = form.getTopiaId();
        if (StringUtils.isNotBlank(topiaId)) {
            serviceWeb.lockOrUnlockInfoAccess(null, topiaId);
        }

        return view(mapping, form, request, response, serviceWeb);
    }

    public ActionForward unlockInfoAccess(ActionMapping mapping, InfoAccessForm form,
                                          HttpServletRequest request, HttpServletResponse response,
                                          ServiceWeb serviceWeb) throws Exception {

        String topiaId = UtilAction.getParameterString(request, "topiaId");

        if (StringUtils.isNotBlank(topiaId)) {
            serviceWeb.lockOrUnlockInfoAccess(null, topiaId);
        }

        chargeEleveur(request, form, serviceWeb);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward requestToUnlock(ActionMapping mapping, InfoAccessForm form,
                                         HttpServletRequest request, HttpServletResponse response,
                                         ServiceWeb serviceWeb) throws Exception {

        String topiaId = UtilAction.getParameterString(request, "infoaccess");
        if (StringUtils.isNotBlank(topiaId)) {
            TaasUser user = ServiceFactory.newServiceWeb().getUser();
            Eleveur eleveur = getEleveur(request, form, serviceWeb);
            ServiceFactory.newServiceNotifier().notifyEvent("requestUnlockInfoAccess",
                    ServiceHelper.getSandraUrl(),
                    user.getLogin(),
                    eleveur.getTopiaId(),
                    topiaId);
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward save(ActionMapping mapping, InfoAccessForm form,
                              HttpServletRequest request, HttpServletResponse response,
                              ServiceWeb serviceWeb) throws Exception {

        serviceWeb.saveInfoAccess(null, form.toBean(), cachedEleveurTopiaId);

        chargeEleveur(request, form, serviceWeb);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    protected void chargeEleveur(HttpServletRequest request, InfoAccessForm form, ServiceWeb serviceWeb) {
        try {
            Eleveur eleveur = getEleveur(request, form, serviceWeb);
            request.setAttribute("topiaId", eleveur.getTopiaId());

            BreederForm breederForm = new BreederForm();
            breederForm.fromBean(eleveur);

            request.setAttribute("breeder", breederForm);
        } catch (Exception ex) {
            log.error("Cant create breeder form ", ex);
        }

    }

    protected Eleveur getEleveur(HttpServletRequest request, InfoAccessForm form, ServiceWeb serviceWeb) {
        if (cachedEleveur == null) {
            try {
                if (cachedEleveurTopiaId == null) {
                    if (form != null && form.getEleveurTopiaId() != null && !form.getEleveurTopiaId().trim().isEmpty()) {
                        cachedEleveurTopiaId = form.getEleveurTopiaId();
                        log.info("form.getEleveurTopiaId() != null " + cachedEleveurTopiaId);
                    }
                }
                if (cachedEleveurTopiaId == null) {
                    String infoAccessTopiaId = UtilAction.getParameterString(request, "topiaId");
                    cachedEleveur = serviceWeb.findEleveurByAccesSilo(null, infoAccessTopiaId);
                    cachedEleveurTopiaId = cachedEleveur.getTopiaId();
                } else {
                    cachedEleveur = serviceWeb.getEleveur(null, cachedEleveurTopiaId);
                }
            } catch (BadInputException ex) {
                log.info("Eleveur not found : ", ex);
            } catch (TopiaException ex) {
                log.info("Eleveur not found : ", ex);
            } catch (LogicException ex) {
                log.info("Eleveur not found : ", ex);
            }
        }

        return cachedEleveur;
    }
}
