package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import com.cybelia.sandra.web.action.ServiceFactory;
import com.cybelia.sandra.web.displaytag.AbstractPaginedListExtractor;
import com.cybelia.sandra.web.displaytag.PaginedListImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.nuiton.topia.TopiaException;

public class BreederSearchAction extends com.cybelia.sandra.web.action.CommonMappingDispatchAction {

    @Override
    protected Object[] getArgs(ActionMapping mapping, ActionForm form,
                               HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new Object[]{mapping, form, request, ServiceFactory.newServiceWeb()};
    }

    public ActionForward list(ActionMapping mapping, BreederSearchForm form,
                                HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {

        request.setAttribute("criteria", form);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward search(ActionMapping mapping, BreederSearchForm form,
                                HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {

        EleveurPaginedListExtractor extractor = new EleveurPaginedListExtractor(serviceWeb, form);
        PaginedListImpl<Eleveur> paginedList = new PaginedListImpl<Eleveur>(extractor);
        paginedList.fromRequest(request).acquireData(request);

        request.setAttribute("breeders", paginedList);
        String eleveurDuplicated = form.getEleveurDuplicated();
        if (eleveurDuplicated != null) {
            request.setAttribute("breederDuplicatedTopiaId", eleveurDuplicated);
        }
        request.setAttribute("criteria", form);

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public ActionForward registerBreederAsDuplicated(ActionMapping mapping, BreederSearchForm form,
                                                     HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {

        String topiaId = request.getParameter("topiaId");

        form.setEleveurDuplicated(topiaId);
        request.setAttribute("breederDuplicatedTopiaId", topiaId);

        return list(mapping, form, request, serviceWeb);
    }

    public ActionForward breederDuplicatedSelected(ActionMapping mapping, BreederSearchForm form,
                                                     HttpServletRequest request, ServiceWeb serviceWeb) throws Exception {

        Eleveur eleveur = serviceWeb.registerBreederAsDuplicated(null, form.getEleveur(), form.getEleveurDuplicated());


        if (eleveur == null) {
            request.setAttribute("breederDuplicatedTopiaId", form.getEleveurDuplicated());
            return mapping.findForward(ERROR_FORWARD);
        }
        request.setAttribute("topidaId", eleveur.getTopiaId());

        return mapping.findForward(SUCCESS_FORWARD);
    }

    public static class EleveurPaginedListExtractor extends AbstractPaginedListExtractor<Eleveur> {

        private static final long serialVersionUID = 3818166383606197935L;

        protected BreederSearchForm criteria;

        public EleveurPaginedListExtractor(ServiceWeb service, BreederSearchForm criteria) {
            super(service);
            this.criteria = criteria;
        }

        public Eleveur getBean(String topiaId) throws LogicException, TopiaException {
            return service.getEleveur(null, topiaId);
        }

        protected Eleveur saveBean(Eleveur bean) throws LogicException, TopiaException {
            return service.saveEleveur(null, bean);
        }

        public int getFullListSize(HttpServletRequest request) throws Exception {
            return service.getEleveursCount(
                    null, criteria.getQuery(),
                    criteria.getGpsKey(),
                    criteria.getNivSecu(),
                    criteria.getCamion(),
                    criteria.getSociete(),
                    criteria.getLivraisonDate(),
                    criteria.getOperator());
        }

        public List<Eleveur> getList(HttpServletRequest request, int startIndex, int endIndex, String sortCriterion, int sortDirection) throws Exception {
            return service.getEleveurs(
                    null, criteria.getQuery(),
                    criteria.getGpsKey(),
                    criteria.getNivSecu(),
                    criteria.getCamion(),
                    criteria.getSociete(),
                    criteria.getLivraisonDate(),
                    criteria.getOperator(),
                    startIndex, endIndex, sortCriterion, sortDirection);
        }
    }
}
