package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.entities.Note;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.sig.PointGPS;
import com.cybelia.sandra.entities.sig.TraceGPS;
import com.cybelia.sandra.web.action.UtilAction;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class BreederForm extends ActionForm {

    private static final long serialVersionUID = 1L;

    protected String topiaId;
    protected String society;
    protected String societyName;
    protected String code;
    protected String telephone;
    protected String mobile;
    protected String raisonSociale;
    protected String adresse;
    protected String codePostal;
    protected String ville;
    protected int niveauSecurite;
    protected String email;
    protected String codeINSEE;
    protected String commentaire;
    protected String contrainteHoraire;
    protected boolean tomTomGPSLocked;
    protected double latitude;
    protected double longitude;
    protected transient List<Note> notes;
    protected transient Collection<InfoAccess> accesSilos;
    protected transient InfoAccess accesEleveur;
    protected String accesTopiaId;
    protected String accesSilo;
    protected String modeChargement;
    protected String nomAccess;
    protected int type;
    protected int accessNiveauSecurite;
    protected String commentSecurite;
    protected String[] risques;
    protected int etat;
    protected PointGPS gps;
    protected TraceGPS traceGPS;
    protected boolean existingGPS;
    protected String eleveurTopiaId;

    public BreederForm() throws Exception {
        latitude = 0;
        longitude = 0;
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public String getAccesSilo() {
        return accesSilo;
    }

    public void setAccesSilo(String accesSilo) {
        this.accesSilo = accesSilo;
    }

    public String getAccesTopiaId() {
        return accesTopiaId;
    }

    public void setAccesTopiaId(String accesTopiaId) {
        this.accesTopiaId = accesTopiaId;
    }

    public int getAccessNiveauSecurite() {
        return accessNiveauSecurite;
    }

    public void setAccessNiveauSecurite(int accessNiveauSecurite) {
        this.accessNiveauSecurite = accessNiveauSecurite;
    }

    public String getCommentSecurite() {
        return commentSecurite;
    }

    public void setCommentSecurite(String commentSecurite) {
        this.commentSecurite = commentSecurite;
    }

    public String getEleveurTopiaId() {
        return eleveurTopiaId;
    }

    public void setEleveurTopiaId(String eleveurTopiaId) {
        this.eleveurTopiaId = eleveurTopiaId;
    }

    public int getEtat() {
        return etat;
    }

    public void setEtat(int etat) {
        this.etat = etat;
    }

    public boolean isExistingGPS() {
        return existingGPS;
    }

    public void setExistingGPS(boolean existingGPS) {
        this.existingGPS = existingGPS;
    }

    public PointGPS getGps() {
        return gps;
    }

    public void setGps(PointGPS gps) {
        this.gps = gps;
    }

    public String getModeChargement() {
        return modeChargement;
    }

    public void setModeChargement(String modeChargement) {
        this.modeChargement = modeChargement;
    }

    public String getNomAccess() {
        return nomAccess;
    }

    public void setNomAccess(String nomAccess) {
        this.nomAccess = nomAccess;
    }

    public String[] getRisques() {
        return risques;
    }

    public void setRisques(String[] risques) {
        this.risques = risques;
    }

    public TraceGPS getTraceGPS() {
        return traceGPS;
    }

    public void setTraceGPS(TraceGPS traceGPS) {
        this.traceGPS = traceGPS;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getAdresse() {
        return adresse;
    }

    public void setAdresse(String adresse) {
        this.adresse = adresse;
    }

    public String getCodePostal() {
        return codePostal;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public String getRaisonSociale() {
        return raisonSociale;
    }

    public void setRaisonSociale(String raisonSociale) {
        this.raisonSociale = raisonSociale;
    }

    public String getVille() {
        return ville;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    public String getCodeINSEE() {
        return codeINSEE;
    }

    public void setCodeINSEE(String codeINSEE) {
        this.codeINSEE = codeINSEE;
    }

    public String getCommentaire() {
        return commentaire;
    }

    public void setCommentaire(String commentaire) {
        this.commentaire = commentaire;
    }

    public String getContrainteHoraire() {
        return contrainteHoraire;
    }

    public void setContrainteHoraire(String contrainteHoraire) {
        this.contrainteHoraire = contrainteHoraire;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public int getNiveauSecurite() {
        return niveauSecurite;
    }

    public void setNiveauSecurite(int niveauSecurite) {
        this.niveauSecurite = niveauSecurite;
    }

    public String getTelephone() {
        return telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSociety() {
        return society;
    }

    public void setSociety(String society) {
        this.society = society;
    }

    public Collection<Note> getNotes() {

        if (notes != null) {
            Collections.sort(notes, new Comparator<Note>() {
                public int compare(Note note, Note other) {
                    return note.getDescription().compareTo(other.getDescription());
                }
            });
        }
        return notes;
    }

    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public int getNoteSize() {
        return notes == null ? 0 : notes.size();
    }

    public boolean isHasTomTomGPS() {
        return !(getLatitude() == 0 && getLongitude() == 0);
    }

    public boolean isTomTomGPSLocked() {
        return tomTomGPSLocked;
    }

    public void setTomTomGPSLocked(boolean tomTomGPSLocked) {
        this.tomTomGPSLocked = tomTomGPSLocked;
    }

    public String getSocietyName() {
        return societyName;
    }

    public void setSocietyName(String societyName) {
        this.societyName = societyName;
    }

    public InfoAccess getAccesEleveur() {
        return accesEleveur;
    }

    public void setAccesEleveur(InfoAccess accesEleveur) {
        this.accesEleveur = accesEleveur;
    }

    public Collection<InfoAccess> getAccesSilos() {
        return accesSilos;
    }

    public void setAccesSilos(Collection<InfoAccess> accesSilos) {
        this.accesSilos = accesSilos;
    }

    protected List<String> getListRisques() {
        List<String> result = new ArrayList<String>();
        String[] risks = getRisques();
        if (risks != null) {
            for (String s : risks) {
                result.add(s);
            }
        }
        return result;
    }

    public String getTitle() {
        return SandraHelper.getEleveurTitle(getRaisonSociale(), getSocietyName(), getCode(), getVille(), getCodePostal());
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "topiaId", "error.breeder.required");
        UtilAction.checkRequiredField(request, errors, "latitude", "error.breeder.latitude.required");
        UtilAction.checkRequiredField(request, errors, "longitude", "error.breeder.longitude.required");

        return errors;
    }

    public Point getPoint() {
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(getLongitude(), getLatitude());
        return geometryFactory.createPoint(coordinate);
    }

    public void fromBean(Eleveur bean) {
        setTopiaId(bean.getTopiaId());
        setSociety(bean.getSociete().getTopiaId());
        setSocietyName(bean.getSociete().getCode());
        setCode(bean.getCode());
        setRaisonSociale(bean.getRaisonSociale());
        setTelephone(bean.getTelephone());
        setMobile(bean.getMobile());
        setAdresse(bean.getAdresse());
        setCodePostal(bean.getCodePostal());
        setVille(bean.getVille());
        setNiveauSecurite(SandraHelper.getWorstSecurityLevel(bean));
        setEmail(bean.getEmail());
        setCodeINSEE(bean.getCodeINSEE());
        setCommentaire(bean.getCommentaire());
        setContrainteHoraire(bean.getContrainteHoraire());
        setTomTomGPSLocked(bean.getNbTomTomGPSModif() > 3);
        setNotes(new ArrayList(bean.getNotes()));
        if (bean.getTomtomGPS() != null) {
            setLongitude(bean.getTomtomGPS().getPoint().getX());
            setLatitude(bean.getTomtomGPS().getPoint().getY());
        } else {
            setLatitude(0);
            setLongitude(0);
        }
        setAccesEleveur(bean.getAccesEleveur());
        setAccesSilos(bean.getActiveAccesSilo());

        // Acces eleveur
        setAccesTopiaId(bean.getAccesEleveur().getTopiaId());
        setAccesSilo(bean.getAccesEleveur().getAccesSilo());
        setCommentSecurite(bean.getAccesEleveur().getCommentaireSecurite());
        setModeChargement(bean.getAccesEleveur().getModeChargement());
        setAccessNiveauSecurite(bean.getAccesEleveur().getNiveauSecurite());
        setNomAccess(bean.getAccesEleveur().getNomAcces());
        risques = bean.getAccesEleveur().getRisques().toArray(new String[0]);
        setEtat(bean.getAccesEleveur().getEtat());
        setType(bean.getAccesEleveur().getType());
        setGps(bean.getAccesEleveur().getGps());
        setExistingGPS(bean.getAccesEleveur().getGps() != null);
    }

    public Eleveur toBean() {
        Eleveur bean = new com.cybelia.sandra.entities.EleveurImpl();

        // https://jira.groupe-glon.fr/browse/SDRAMTNC-295
        // set raisonSocial, adresse and ville only on creation and on web
        bean.setRaisonSociale(getRaisonSociale());

        bean.setTopiaId(getTopiaId());
        bean.setCode(getCode());
        bean.setTelephone(getTelephone());
        bean.setMobile(getMobile());
        bean.setAdresse(getAdresse());
        bean.setCodePostal(getCodePostal());
        bean.setVille(getVille());
        bean.setEmail(getEmail());
        bean.setCodeINSEE(getCodeINSEE());
        bean.setContrainteHoraire(getContrainteHoraire());
        bean.setCommentaire(getCommentaire());

        Societe societe = new com.cybelia.sandra.entities.SocieteImpl();
        societe.setTopiaId(getSociety());
        bean.setSociete(societe);

        PointGPS pointGPS = new com.cybelia.sandra.entities.sig.PointGPSImpl();
        pointGPS.setPoint(getPoint());
        bean.setTomtomGPS(pointGPS);

        // Notes
        bean.setNotes(notes);

        // Acces eleveur
        InfoAccess acces = new com.cybelia.sandra.entities.InfoAccessImpl();
        acces.setTopiaId(getAccesTopiaId());
        acces.setAccesSilo(getAccesSilo());
        acces.setCommentaireSecurite(getCommentSecurite());
        acces.setGps(getGps());
        acces.setModeChargement(getModeChargement());
        acces.setNiveauSecurite(getAccessNiveauSecurite());
        acces.setNomAcces(getNomAccess());
        acces.setRisques(getListRisques());
        acces.setEtat(getEtat());
        acces.setTrace(getTraceGPS());
        acces.setType(getType());

        bean.setAccesEleveur(acces);

        return bean;
    }
}
