package com.cybelia.sandra.web.action.breeder;

import com.cybelia.sandra.entities.ActionSecurite;
import com.cybelia.sandra.entities.ActionSecuriteImpl;
import com.cybelia.sandra.entities.Eleveur;
import com.cybelia.sandra.entities.InfoAccess;
import com.cybelia.sandra.web.action.UtilAction;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class ActionSecurityForm extends ActionForm {

    private static final long serialVersionUID = 1L;

    protected String topiaId;
    protected Date dateCreation;
    protected String userCreation;
    protected Date dateAction;
    protected String commentaire;
    protected InfoAccess infoAccess;
    protected String infoAccessTopiaId;
    protected Eleveur eleveur;
    protected String eleveurTopiaId;
    protected String type;

    public ActionSecurityForm() {
        this.dateAction = new Date();
    }

    public String getTopiaId() {
        return topiaId;
    }

    public void setTopiaId(String topiaId) {
        this.topiaId = topiaId;
    }

    public Date getDateCreation() {
        return dateCreation;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public String getUserCreation() {
        return userCreation;
    }

    public void setUserCreation(String userCreation) {
        this.userCreation = userCreation;
    }

    public Date getDateAction() {
        return dateAction;
    }

    public void setDateAction(Date dateAction) {
        this.dateAction = dateAction;
    }

    public InfoAccess getInfoAccess() {
        return infoAccess;
    }

    public void setInfoAccess(InfoAccess infoAccess) {
        this.infoAccess = infoAccess;
    }

    public String getInfoAccessTopiaId() {
        return infoAccessTopiaId;
    }

    public void setInfoAccessTopiaId(String infoAccessTopiaId) {
        this.infoAccessTopiaId = infoAccessTopiaId;
    }

    public Eleveur getEleveur() {
        return eleveur;
    }

    public void setEleveur(Eleveur eleveur) {
        this.eleveur = eleveur;
    }

    public String getEleveurTopiaId() {
        return eleveurTopiaId;
    }

    public void setEleveurTopiaId(String eleveurTopiaId) {
        this.eleveurTopiaId = eleveurTopiaId;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCommentaire() {
        return commentaire;
    }

    public void setCommentaire(String commentaire) {
        this.commentaire = commentaire;
    }

    @Override
    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();

        UtilAction.checkRequiredField(request, errors, "type", "error.action.type.required");

        return errors;
    }

    public void fromBean(ActionSecurite bean) {
        setTopiaId(bean.getTopiaId());
        setType(bean.getType());
        setDateCreation(bean.getDateCreation());
        setUserCreation(bean.getUserCreation());
        setDateAction(bean.getDateAction());
        setCommentaire(bean.getCommentaire());
        Eleveur breeder = bean.getEleveur();
        setEleveur(breeder);
        setEleveurTopiaId(breeder.getTopiaId());
        InfoAccess silo = bean.getInfoAccess();
        if (silo != null) {
            setInfoAccess(silo);
            setInfoAccessTopiaId(silo.getTopiaId());
        }
    }

    public void fromBean(Eleveur bean) {
        setTopiaId(null);
        setType(null);
        setCommentaire(null);
        setEleveur(bean);
        setEleveurTopiaId(bean.getTopiaId());
        setDateAction(new Date());
        setInfoAccess(null);
        setInfoAccessTopiaId(null);
    }

    public ActionSecurite toBean() {
        ActionSecurite actionSecurite = new ActionSecuriteImpl();
        actionSecurite.setTopiaId(getTopiaId());
        actionSecurite.setType(getType());
        Date dateAction = getDateAction();
        if (dateAction == null) {
            dateAction = new Date();
        }
        actionSecurite.setDateAction(dateAction);
        actionSecurite.setEleveur(getEleveur());
        actionSecurite.setInfoAccess(getInfoAccess());
        actionSecurite.setCommentaire(getCommentaire());
        return actionSecurite;
    }
}
