package com.cybelia.sandra.web.action;

import com.cybelia.sandra.services.LogicException;
import com.cybelia.sandra.services.ServiceWeb;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

//import javax.ejb.EJBAccessException;

public class ErrorAction extends CommonAction {

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response,
                                 ApplicationSession applicationSession, ServiceWeb serviceWeb)
            throws Exception {

        Exception exception = (Exception) request.getAttribute(Globals.EXCEPTION_KEY);

        if (findCause(exception, LogicException.class)) {
            request.setAttribute("isLogicException", true);
            request.setAttribute("logicException", exception);
            log.error("logicException", exception);

        } else if (exception instanceof SecurityException) {
            request.setAttribute("isSecurityException", true);
            request.setAttribute("isSecurityExceptionPage", true);
            log.error("isSecurityExceptionPage", exception);

        } else if (findCause(exception, SecurityException.class)) {
            request.setAttribute("isSecurityException", true);
            request.setAttribute("isSecurityExceptionAction", true);
            request.setAttribute("securityException", exception);
            log.error("isSecurityExceptionAction", exception);

        } /*else if (exception instanceof EJBAccessException) {
            log.error("eJBAccessException", exception);
            return mapping.findForward(LOGOUT_FORWARD);

        } */ else {
            request.setAttribute("isTechnicalException", true);
            request.setAttribute("technicalException", exception);
            log.error("technicalException", exception);
        }
        return mapping.findForward(SUCCESS_FORWARD);
    }

    /**
     * Recherche la cause de l'exception parmis une exception.
     *
     * @param e           exception dans laquelle rechercher
     * @param classeCause classe de la cause a chercher
     * @return si la cause a ete trouvee
     */
    protected boolean findCause(Throwable e, Class<? extends Throwable> classeCause) {
        return e != null && (classeCause == e.getClass() || findCause(e.getCause(), classeCause));

    }
}