package com.cybelia.sandra.web.action;

import com.cybelia.sandra.services.ServiceWeb;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public abstract class CommonAction extends Action {

    protected final Log log = LogFactory.getLog(getClass());
    public final static String SUCCESS_FORWARD = "success";
    public final static String NEW_FORWARD = "new";
    public final static String MODIFY_FORWARD = "modify";
    public final static String LOGOUT_FORWARD = "logout";

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form,
                                 HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        ActionForward forward = execute(mapping, form, request, response,
                ApplicationSession.get(request),
                ServiceFactory.newServiceWeb());
        return forward;
    }

    public abstract ActionForward execute(ActionMapping mapping, ActionForm form,
                                          HttpServletRequest request, HttpServletResponse response,
                                          ApplicationSession applicationSession, ServiceWeb serviceWeb) throws Exception;

    protected void loginfo(String msg) {
        if (log.isInfoEnabled()) {
            log.info(msg);
        }
    }

    protected void logdebug(String msg) {
        if (log.isDebugEnabled()) {
            log.debug(msg);
        }
    }
}
