/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal;

import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MethodSignature {
    private final String name;
    private final List<String> paramTypes;

    private MethodSignature(String methodName, List<String> paramTypes) {
        this.name = Objects.requireNonNull(methodName);
        this.paramTypes = RuntimeJavadocHelper.unmodifiableDefensiveCopy(paramTypes);
    }

    public static MethodSignature from(MethodJavadoc methodJavadoc) {
        return new MethodSignature(methodJavadoc.getName(), methodJavadoc.getParamTypes());
    }

    public static MethodSignature from(Executable executable) {
        String name;
        List<String> paramTypes = Arrays.stream(executable.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.toList());
        if (executable instanceof Method) {
            name = executable.getName();
        } else if (executable instanceof Constructor) {
            name = "<init>";
        } else {
            throw new IllegalArgumentException("Unexpected executable type: " + executable.getClass());
        }
        return new MethodSignature(name, paramTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.paramTypes, that.paramTypes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.paramTypes);
    }

    public String toString() {
        return this.name + "(" + String.join((CharSequence)",", this.paramTypes) + ")";
    }
}

