/*
 * Decompiled with CFR 0.152.
 */
package tray.balloon;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class InfoWindow
extends Window {
    Container container = new Container(){

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    };
    Closer closer;

    InfoWindow(Frame parent, Color borderColor) {
        super(parent);
        this.setLayout(new BorderLayout());
        this.setBackground(borderColor);
        this.add((Component)this.container, "Center");
        this.container.setLayout(new BorderLayout());
        this.closer = new Closer();
    }

    @Override
    public Component add(Component c) {
        this.container.add(c, "Center");
        return c;
    }

    void setCloser(Runnable action, int time) {
        this.closer.set(action, time);
    }

    protected void show(Point corner, int indent) {
        this.pack();
        Dimension size = this.getSize();
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (corner.x < scrSize.width / 2 && corner.y < scrSize.height / 2) {
            this.setLocation(corner.x + indent, corner.y + indent);
        } else if (corner.x >= scrSize.width / 2 && corner.y < scrSize.height / 2) {
            this.setLocation(corner.x - indent - size.width, corner.y + indent);
        } else if (corner.x < scrSize.width / 2 && corner.y >= scrSize.height / 2) {
            this.setLocation(corner.x + indent, corner.y - indent - size.height);
        } else if (corner.x >= scrSize.width / 2 && corner.y >= scrSize.height / 2) {
            this.setLocation(corner.x - indent - size.width, corner.y - indent - size.height);
        }
        InfoWindow.super.show();
        this.closer.schedule();
    }

    @Override
    public void hide() {
        this.closer.close();
    }

    class Closer
    implements Runnable {
        Runnable action;
        int time;

        Closer() {
        }

        @Override
        public void run() {
            this.doClose();
        }

        void set(Runnable action, int time) {
            this.action = action;
            this.time = time;
        }

        void schedule() {
        }

        void close() {
            this.doClose();
        }

        private void doClose() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InfoWindow.super.hide();
                    InfoWindow.this.invalidate();
                    if (Closer.this.action != null) {
                        Closer.this.action.run();
                    }
                }
            });
        }
    }
}

