/*
 * Decompiled with CFR 0.152.
 */
package jni.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtils {
    public static File getStreamAsTempFile(InputStream in, String fileNamePrefix, String extension) throws IOException, FileNotFoundException {
        File libraryFile = File.createTempFile(fileNamePrefix, extension);
        libraryFile.deleteOnExit();
        StreamUtils.writeStreamToFile(in, libraryFile);
        return libraryFile;
    }

    public static File getStreamAsTempFileOrCry(InputStream in, String fileNamePrefix) {
        try {
            return StreamUtils.getStreamAsTempFile(in, fileNamePrefix, null);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeStreamToFile(InputStream aStream, File targetFile) throws FileNotFoundException, IOException {
        int count;
        FileOutputStream out = new FileOutputStream(targetFile);
        byte[] buffer = new byte[1024];
        while (0 < (count = aStream.read(buffer))) {
            out.write(buffer, 0, count);
        }
    }
}

