/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.scopes.ComposedDumbScope;
import com.github.sommeri.less4j.core.compiler.scopes.ILocalScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScopesTree;
import java.util.Iterator;
import java.util.List;

public class BasicScope
extends ComposedDumbScope
implements IScope {
    public BasicScope(ILocalScope localScope, IScopesTree surroundingScopes) {
        super(localScope, surroundingScopes);
    }

    @Override
    public IScope firstChild() {
        return this.getChilds().get(0);
    }

    @Override
    public Expression getValue(Variable variable) {
        return this.getValue(variable.getName());
    }

    @Override
    public Expression getValue(String name) {
        Expression value = this.getLocalValue(name);
        if (value == null && this.hasParent()) {
            value = this.getParent().getValue(name);
        }
        return value;
    }

    @Override
    public IScope childByOwners(ASTCssNode headNode, ASTCssNode ... restNodes) {
        IScope head = this.getChildOwnerOf(headNode);
        if (head == null) {
            return null;
        }
        for (ASTCssNode node : restNodes) {
            if ((head = head.getChildOwnerOf(node)) != null) continue;
            return null;
        }
        return head;
    }

    @Override
    public IScope getChildOwnerOf(ASTCssNode body) {
        for (IScope kid : this.getChilds()) {
            if (kid.getOwner() != body) continue;
            return kid;
        }
        return null;
    }

    @Override
    public boolean seesLocalDataOf(IScope otherScope) {
        if (this.getLocalScope().hasTheSameLocalData(otherScope.getLocalScope())) {
            return true;
        }
        if (!this.hasParent()) {
            return false;
        }
        return this.getParent().seesLocalDataOf(otherScope);
    }

    @Override
    public IScope getRootScope() {
        if (!this.hasParent()) {
            return this;
        }
        return this.getParent().getRootScope();
    }

    @Override
    public IScope skipBodyOwner() {
        if (this.isBodyOwnerScope()) {
            return this.firstChild().skipBodyOwner();
        }
        return this;
    }

    @Override
    public void setParentKeepConsistency(IScope parent) {
        if (this.getSurroundingScopes().hasParent()) {
            this.getParent().getChilds().remove(this);
        }
        this.setParent(parent);
        if (parent != null) {
            parent.addChild(this);
        }
    }

    @Override
    public void setParent(IScope parent) {
        this.getSurroundingScopes().setParent(parent);
    }

    public void replaceChild(IScope parent, IScope child, List<IScope> replacements) {
        List<IScope> inList = parent.getChilds();
        int indexOf = inList.indexOf(child);
        inList.remove(indexOf);
        inList.addAll(indexOf, replacements);
        for (IScope kid : replacements) {
            kid.setParent(parent);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.toFullName());
        return result.toString();
    }

    @Override
    public String toFullName() {
        if (this.hasParent()) {
            return this.getParent().toFullName() + " > " + this.toSimpleName();
        }
        return this.toSimpleName().toString();
    }

    private String toSimpleName() {
        List<String> names = this.getNames();
        return "" + this.getType() + names;
    }

    @Override
    public String toLongString() {
        return this.toLongString(0).toString();
    }

    @Override
    public StringBuilder toLongString(int level) {
        String prefix = "";
        for (int i = 0; i < level; ++i) {
            prefix = prefix + "  ";
        }
        StringBuilder text = new StringBuilder(prefix);
        Iterator<String> iNames = this.getNames().iterator();
        text.append(iNames.next());
        while (iNames.hasNext()) {
            text.append(", ").append(iNames.next());
        }
        text.append("(").append(this.getLocalVariables().size()).append(", ").append(this.getLocalMixins().size());
        text.append(") {").append("\n");
        for (IScope kid : this.getChilds()) {
            text.append((CharSequence)kid.toLongString(level + 1));
        }
        text.append(prefix).append("}").append("\n");
        return text;
    }
}

