/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ComparisonExpressionOperator;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class ComparisonExpression
extends Expression {
    private Expression left;
    private ComparisonExpressionOperator operator;
    private Expression right;

    public ComparisonExpression(HiddenTokenAwareTree underlyingStructure) {
        super(underlyingStructure);
    }

    public ComparisonExpression(HiddenTokenAwareTree underlyingStructure, Expression left, ComparisonExpressionOperator operator, Expression right) {
        super(underlyingStructure);
        this.left = left;
        this.operator = operator;
        this.right = right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public ComparisonExpressionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ComparisonExpressionOperator operator) {
        this.operator = operator;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.COMPARISON_EXPRESSION;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.left, this.operator, this.right);
    }

    @Override
    public String toString() {
        return "[" + this.left + this.operator + this.right + "]";
    }

    @Override
    public ComparisonExpression clone() {
        ComparisonExpression result = (ComparisonExpression)super.clone();
        result.left = this.left == null ? null : this.left.clone();
        result.operator = this.operator == null ? null : this.operator.clone();
        result.right = this.right == null ? null : this.right.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

