/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.validators;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SupportedLessBodyMembers {
    private static final Set<ASTCssNodeType> KEYFRAMES_SUPPORTED_MEMBERS = new HashSet<ASTCssNodeType>();

    public Set<ASTCssNodeType> getSupportedMembers(Body node) {
        if (node.getParent() != null) {
            return this.getSupportedMembers(node.getType(), node.getParent().getType());
        }
        return this.getSupportedMembers(node.getType(), null);
    }

    public Set<ASTCssNodeType> getSupportedMembers(ASTCssNodeType bodyType, ASTCssNodeType ownerType) {
        switch (bodyType) {
            case STYLE_SHEET: {
                Set<ASTCssNodeType> result = this.allNodeTypes();
                result.remove((Object)ASTCssNodeType.DECLARATION);
                result.remove((Object)ASTCssNodeType.PAGE_MARGIN_BOX);
                return result;
            }
        }
        if (ownerType == null) {
            return this.allNodeTypes();
        }
        switch (ownerType) {
            case KEYFRAMES: {
                return Collections.unmodifiableSet(KEYFRAMES_SUPPORTED_MEMBERS);
            }
        }
        return this.allNodeTypes();
    }

    private Set<ASTCssNodeType> allNodeTypes() {
        return new HashSet<ASTCssNodeType>(Arrays.asList(ASTCssNodeType.values()));
    }

    static {
        KEYFRAMES_SUPPORTED_MEMBERS.add(ASTCssNodeType.RULE_SET);
        KEYFRAMES_SUPPORTED_MEMBERS.add(ASTCssNodeType.MIXIN_REFERENCE);
        KEYFRAMES_SUPPORTED_MEMBERS.add(ASTCssNodeType.REUSABLE_STRUCTURE);
        KEYFRAMES_SUPPORTED_MEMBERS.add(ASTCssNodeType.VARIABLE_DECLARATION);
    }
}

