/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.problems.BugHappened;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SelectorsManipulator {
    public List<Selector> replaceAppenders(Selector inSelector, List<Selector> replacements) {
        if (!inSelector.containsAppender()) {
            return this.indirectJoinAll(replacements, null, inSelector);
        }
        List<Selector> result = Arrays.asList(inSelector);
        while (result.get(0).containsAppender()) {
            ArrayList<Selector> nextRound = new ArrayList<Selector>();
            for (Selector tbch : result) {
                nextRound.addAll(this.replaceFirstAppender(tbch, replacements));
            }
            result = nextRound;
        }
        return result;
    }

    private List<Selector> indirectJoinAll(List<Selector> first, SelectorCombinator combinator, Selector second) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector previous : first) {
            result.add(this.indirectJoin(previous, combinator, second));
        }
        return result;
    }

    public Selector indirectJoin(Selector firstI, SelectorCombinator combinator, Selector secondI) {
        if (secondI == null) {
            return firstI.clone();
        }
        if (firstI == null) {
            return secondI.clone();
        }
        Selector first = firstI.clone();
        Selector second = secondI.clone();
        this.indirectJoinNoClone(first, combinator, second);
        return first;
    }

    public Selector indirectJoinNoClone(Selector first, SelectorCombinator combinator, Selector second) {
        Selector attachTo = first.getRightestPart();
        attachTo.setRight(second);
        second.setParent(attachTo);
        if (combinator != null) {
            second.setLeadingCombinator(combinator);
        }
        return first;
    }

    public Selector directJoin(Selector firstI, Selector secondI) {
        if (secondI == null) {
            return firstI.clone();
        }
        if (firstI == null) {
            return secondI.clone();
        }
        Selector first = firstI.clone();
        Selector second = secondI.clone();
        if (second.getHead().isAppender()) {
            return this.indirectJoinNoClone(first, second.getLeadingCombinator(), second);
        }
        Selector attachTo = first.getRightestPart();
        SimpleSelector attachToHead = (SimpleSelector)attachTo.getHead();
        SimpleSelector secondHead = (SimpleSelector)second.getHead();
        if (!secondHead.hasElement()) {
            attachToHead.addSubsequent(secondHead.getSubsequent());
        } else {
            String secondName;
            String string = secondName = secondHead.hasElement() ? secondHead.getElementName().getName() : "";
            if (attachToHead.hasSubsequent()) {
                ElementSubsequent subsequent = attachToHead.getLastSubsequent();
                subsequent.extendName(secondName);
            } else {
                attachToHead.extendName(secondName);
            }
            attachToHead.addSubsequent(secondHead.getSubsequent());
        }
        attachToHead.configureParentToAllChilds();
        if (second.hasRight()) {
            this.indirectJoinNoClone(attachTo, second.getLeadingCombinator(), second.getRight());
        }
        return first;
    }

    private Collection<Selector> replaceFirstAppender(Selector selector, List<Selector> previousSelectors) {
        if (selector.getHead().isAppender()) {
            NestedSelectorAppender appender = (NestedSelectorAppender)selector.getHead();
            return this.joinAll(previousSelectors, this.chopOffHead(selector), selector.getLeadingCombinator(), appender.isDirectlyBefore());
        }
        NestedSelectorAppender appender = selector.findFirstAppender();
        if (appender == null) {
            throw new BugHappened("This is very weird error and should not happen.", (ASTCssNode)selector);
        }
        Selector rightSelectorBeginning = appender.getParentAsSelector();
        Selector leftSelectorBeginning = this.splitOn(rightSelectorBeginning);
        List<Selector> partialResults = this.joinAll(leftSelectorBeginning, previousSelectors, rightSelectorBeginning.getLeadingCombinator(), appender.isDirectlyAfter());
        return this.joinAll(partialResults, this.chopOffHead(rightSelectorBeginning), null, appender.isDirectlyBefore());
    }

    private List<Selector> joinAll(Selector first, List<Selector> seconds, SelectorCombinator leadingCombinator, boolean appenderDirectlyPlaced) {
        boolean directJoin = this.isDirect(leadingCombinator, appenderDirectlyPlaced);
        if (directJoin) {
            return this.directJoinAll(first, seconds);
        }
        return this.indirectJoinAll(leadingCombinator, first, seconds);
    }

    private List<Selector> joinAll(List<Selector> firsts, Selector second, SelectorCombinator leadingCombinator, boolean appenderDirectlyPlaced) {
        boolean directJoin = this.isDirect(leadingCombinator, appenderDirectlyPlaced);
        if (directJoin) {
            return this.directJoinAll(firsts, second);
        }
        return this.indirectJoinAll(firsts, leadingCombinator, second);
    }

    private Selector chopOffHead(Selector selector) {
        if (!selector.hasRight()) {
            return null;
        }
        Selector right = selector.getRight();
        right.setParent(null);
        selector.setRight(null);
        return right;
    }

    private List<Selector> directJoinAll(List<Selector> firsts, Selector second) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector first : firsts) {
            result.add(this.directJoin(first, second));
        }
        return result;
    }

    private List<Selector> indirectJoinAll(SelectorCombinator leadingCombinator, Selector first, List<Selector> seconds) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector second : seconds) {
            result.add(this.indirectJoin(first, leadingCombinator, second));
        }
        return result;
    }

    private List<Selector> directJoinAll(Selector first, List<Selector> seconds) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector second : seconds) {
            result.add(this.directJoin(first, second));
        }
        return result;
    }

    private boolean isDirect(SelectorCombinator leadingCombinator, boolean appenderDirectlyPlaced) {
        return leadingCombinator == null && appenderDirectlyPlaced;
    }

    private Selector splitOn(Selector rightSelectorStart) {
        Selector leftSelectorEnding = (Selector)rightSelectorStart.getParent();
        leftSelectorEnding.setRight(null);
        rightSelectorStart.setParent(null);
        Selector leftSelectorBeginning = leftSelectorEnding;
        while (leftSelectorBeginning.getParent() instanceof Selector) {
            leftSelectorBeginning = (Selector)leftSelectorBeginning.getParent();
        }
        return leftSelectorBeginning;
    }
}

