/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.AbstractVariableDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.MixinsDefinitionsStorage;
import com.github.sommeri.less4j.core.compiler.scopes.VariablesDeclarationsStorage;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Scope {
    private static final String DEFAULT = "#default#";
    private static final String SCOPE = "#scope#";
    private static final String BODY_OWNER = "#body-owner#";
    private static final String DUMMY = "#dummy#";
    private String type;
    private final ASTCssNode owner;
    private boolean presentInTree = true;
    private LocalData localData = new LocalData();
    private Stack<LocalData> localDataSnapshots = new Stack();
    private Scope parent;
    private List<Scope> childs = new ArrayList<Scope>();
    private List<String> names;

    protected Scope(String type, ASTCssNode owner, List<String> names, Scope parent) {
        this.names = names;
        this.owner = owner;
        this.type = type;
        this.setParent(parent);
    }

    private Scope(String type, ASTCssNode owner, String name, Scope parent) {
        this(type, owner, new ArrayList<String>(Arrays.asList(name)), parent);
    }

    protected Scope(String type, ASTCssNode owner, List<String> names) {
        this(type, owner, names, null);
    }

    protected Scope(String type, ASTCssNode owner, String name) {
        this(type, owner, new ArrayList<String>(Arrays.asList(name)), null);
    }

    public void addNames(List<String> names) {
        this.names.addAll(names);
    }

    private void addChild(Scope child) {
        this.childs.add(child);
    }

    public Scope getParent() {
        return this.parent;
    }

    public List<Scope> getChilds() {
        return this.childs;
    }

    public List<String> getNames() {
        return this.names;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.toFullName());
        result.append("\n\n").append(this.localData);
        return result.toString();
    }

    private String toFullName() {
        if (this.hasParent()) {
            return this.getParent().toFullName() + " > " + this.toSimpleName();
        }
        return this.toSimpleName().toString();
    }

    private String toSimpleName() {
        List<String> names = this.getNames();
        return "" + this.type + names;
    }

    public void registerVariable(AbstractVariableDeclaration declaration) {
        this.getLocalVariables().store(declaration);
    }

    public void registerVariable(AbstractVariableDeclaration node, Expression replacementValue) {
        this.getLocalVariables().store(node, replacementValue);
    }

    public void registerVariableIfNotPresent(String name, Expression replacementValue) {
        this.getLocalVariables().storeIfNotPresent(name, replacementValue);
    }

    public void registerVariable(String name, Expression replacementValue) {
        this.getLocalVariables().store(name, replacementValue);
    }

    public void fillByFilteredVariables(ExpressionFilter filter, Scope source) {
        this.getLocalVariables().fillByFilteredVariables(filter, source.getLocalVariables());
    }

    public void addAllMixins(List<FullMixinDefinition> mixins) {
        this.getLocalMixins().storeAll(mixins);
    }

    public void add(Scope otherSope) {
        this.getLocalMixins().storeAll(otherSope.getLocalMixins());
        this.getLocalVariables().storeAll(otherSope.getLocalVariables());
    }

    public Expression getValue(Variable variable) {
        return this.getValue(variable.getName());
    }

    public Expression getValue(String name) {
        Expression value = this.getLocalVariables().getValue(name);
        if (value == null && this.hasParent()) {
            return this.getParent().getValue(name);
        }
        return value;
    }

    public void registerMixin(ReusableStructure mixin, Scope mixinsBodyScope) {
        this.getLocalMixins().store(new FullMixinDefinition(mixin, mixinsBodyScope));
    }

    public void createPlaceholder() {
        this.getLocalVariables().createPlaceholder();
        this.getLocalMixins().createPlaceholder();
    }

    public void addToPlaceholder(Scope otherScope) {
        this.getLocalVariables().addToPlaceholder(otherScope.getLocalVariables());
        this.getLocalMixins().addToPlaceholder(otherScope.getLocalMixins());
    }

    public void closePlaceholder() {
        this.getLocalVariables().closePlaceholder();
        this.getLocalMixins().closePlaceholder();
    }

    public List<FullMixinDefinition> getNearestMixins(ReusableStructureName name) {
        ArrayList value = this.getLocalMixins().getMixins(name);
        if ((value == null || value.isEmpty()) && this.hasParent()) {
            return this.getParent().getNearestMixins(name);
        }
        return value == null ? new ArrayList() : value;
    }

    public List<FullMixinDefinition> getAllMixins() {
        return this.getLocalMixins().getAllMixins();
    }

    public List<FullMixinDefinition> getNearestMixins(MixinReference reference, ProblemsHandler problemsHandler) {
        List<Scope> namespaces = this.getNearestNamespaces(reference);
        if (namespaces.isEmpty()) {
            problemsHandler.undefinedNamespace(reference);
        }
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (Scope namespace : namespaces) {
            if (namespace.isBodyOwnerScope()) {
                namespace = namespace.firstChild();
            }
            result.addAll(namespace.getNearestMixins(reference.getFinalName()));
        }
        return result;
    }

    private Scope firstChild() {
        return this.childs.get(0);
    }

    private boolean isBodyOwnerScope() {
        return BODY_OWNER.equals(this.type);
    }

    private List<Scope> getNearestNamespaces(MixinReference reference) {
        List<String> nameChain = reference.getNameChainAsStrings();
        if (nameChain.isEmpty()) {
            return Arrays.asList(this);
        }
        Scope space = this;
        List<Scope> result = this.findMatchingChilds(nameChain);
        while (result.isEmpty() && space.hasParent()) {
            space = space.getParent();
            result = space.findMatchingChilds(nameChain);
        }
        return result;
    }

    public List<Scope> findMatchingChilds(List<String> nameChain) {
        if (nameChain.isEmpty()) {
            return Arrays.asList(this);
        }
        String fistName = nameChain.get(0);
        List<String> theRest = nameChain.subList(1, nameChain.size());
        ArrayList<Scope> result = new ArrayList<Scope>();
        for (Scope kid : this.getChilds()) {
            if (!kid.getNames().contains(fistName)) continue;
            result.addAll(kid.skipBodyOwner().findMatchingChilds(theRest));
        }
        return result;
    }

    private Scope skipBodyOwner() {
        if (this.isBodyOwnerScope()) {
            return this.firstChild().skipBodyOwner();
        }
        return this;
    }

    public static Scope createDefaultScope(ASTCssNode owner) {
        return new Scope(DEFAULT, owner, new ArrayList<String>());
    }

    public static Scope createScope(ASTCssNode owner, Scope parent) {
        return new Scope(SCOPE, owner, new ArrayList<String>(), parent);
    }

    public static Scope createBodyOwnerScope(ASTCssNode owner, Scope parent) {
        return new Scope(BODY_OWNER, owner, new ArrayList<String>(), parent);
    }

    public static Scope createDummyScope() {
        return new Scope(DUMMY, null, new ArrayList<String>(), null);
    }

    public static Scope createDummyScope(ASTCssNode owner, String name) {
        return new Scope(DUMMY, owner, name, null);
    }

    public String toLongString() {
        return this.toLongString(0).toString();
    }

    private StringBuilder toLongString(int level) {
        String prefix = "";
        for (int i = 0; i < level; ++i) {
            prefix = prefix + "  ";
        }
        StringBuilder text = new StringBuilder(prefix);
        Iterator<String> iNames = this.getNames().iterator();
        text.append(iNames.next());
        while (iNames.hasNext()) {
            text.append(", ").append(iNames.next());
        }
        text.append("(").append(this.getLocalVariables().size()).append(", ").append(this.getLocalMixins().size());
        text.append(") {").append("\n");
        for (Scope kid : this.getChilds()) {
            text.append((CharSequence)kid.toLongString(level + 1));
        }
        text.append(prefix).append("}").append("\n");
        return text;
    }

    public Scope copyWithChildChain() {
        return this.copyWithChildChain(null);
    }

    public Scope copyWithChildChain(Scope parent) {
        Scope result = new Scope(this.type, this.owner, new ArrayList<String>(this.getNames()), parent);
        result.localData = this.localData;
        result.presentInTree = this.presentInTree;
        for (Scope kid : this.getChilds()) {
            kid.copyWithChildChain(result);
        }
        return result;
    }

    public Scope copyWithParentsChain() {
        Scope parent = null;
        if (this.hasParent()) {
            parent = this.getParent().copyWithParentsChain();
            for (Scope kid : this.getParent().getChilds()) {
                if (kid == this) continue;
                kid.copyWithChildChain(parent);
            }
        }
        Scope result = new Scope(this.type, this.owner, new ArrayList<String>(this.getNames()), parent);
        result.localData = this.localData;
        result.presentInTree = this.presentInTree;
        return result;
    }

    public Scope copyWholeTree() {
        Scope parentalTree = this.copyWithParentsChain();
        Scope parentalTreeConnector = parentalTree.getParent();
        parentalTree.setParent(null);
        Scope copyWithchildTree = this.copyWithChildChain(parentalTreeConnector);
        return copyWithchildTree;
    }

    public void insertAsParent(Scope parent) {
        Scope originalParent = this.getParent();
        parent.setParent(originalParent);
        this.setParent(parent);
    }

    public void setParent(Scope parent) {
        if (this.hasParent()) {
            this.getParent().getChilds().remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void removedFromTree() {
        this.presentInTree = false;
    }

    public boolean isPresentInTree() {
        return this.presentInTree;
    }

    public Scope getRootScope() {
        if (!this.hasParent()) {
            return this;
        }
        return this.getParent().getRootScope();
    }

    public boolean seesLocalDataOf(Scope otherScope) {
        if (otherScope.localData == this.localData) {
            return true;
        }
        if (!this.hasParent()) {
            return false;
        }
        return this.getParent().seesLocalDataOf(otherScope);
    }

    public Scope getChildOwnerOf(ASTCssNode body) {
        for (Scope kid : this.getChilds()) {
            if (kid.owner != body) continue;
            return kid;
        }
        return null;
    }

    public Scope childByOwners(ASTCssNode headNode, ASTCssNode ... restNodes) {
        Scope head = this.getChildOwnerOf(headNode);
        if (head == null) {
            return null;
        }
        for (ASTCssNode node : restNodes) {
            if ((head = head.getChildOwnerOf(node)) != null) continue;
            return null;
        }
        return head;
    }

    protected void createLocalDataSnapshot() {
        this.localDataSnapshots.push(this.localData);
        this.localData = this.localData.clone();
    }

    protected void discardLastLocalDataSnapshot() {
        this.localData = this.localDataSnapshots.pop();
    }

    private MixinsDefinitionsStorage getLocalMixins() {
        return this.localData.mixins;
    }

    private VariablesDeclarationsStorage getLocalVariables() {
        return this.localData.variables;
    }

    public void createDataClone() {
        this.localData = this.localData.clone();
    }

    class LocalData
    implements Cloneable {
        private VariablesDeclarationsStorage variables = new VariablesDeclarationsStorage();
        private MixinsDefinitionsStorage mixins = new MixinsDefinitionsStorage();

        LocalData() {
        }

        protected LocalData clone() {
            try {
                LocalData clone = (LocalData)super.clone();
                this.variables = Scope.this.getLocalVariables().clone();
                this.mixins = Scope.this.getLocalMixins().clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalStateException("Impossible to happen.");
            }
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("\n");
            result.append("**Variables storage: ").append(this.variables).append("\n\n");
            result.append("**Mixins storage: ").append(this.mixins).append("\n\n");
            return result.toString();
        }
    }
}

