/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Color;
import com.github.sommeri.less4j.core.compiler.expressions.Convert;
import com.github.sommeri.less4j.core.compiler.expressions.Extract;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.compiler.expressions.FunctionsPackage;
import com.github.sommeri.less4j.core.compiler.expressions.Unit;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MiscFunctions
implements FunctionsPackage {
    protected static final String COLOR = "color";
    protected static final String UNIT = "unit";
    protected static final String CONVERT = "convert";
    protected static final String EXTRACT = "extract";
    private static Map<String, Function> FUNCTIONS = new HashMap<String, Function>();
    private final ProblemsHandler problemsHandler;

    public MiscFunctions(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    @Override
    public boolean canEvaluate(FunctionExpression input, List<Expression> parameters) {
        return FUNCTIONS.containsKey(input.getName());
    }

    @Override
    public Expression evaluate(FunctionExpression input, List<Expression> parameters, Expression evaluatedParameter) {
        if (!this.canEvaluate(input, parameters)) {
            return input;
        }
        Function function = FUNCTIONS.get(input.getName());
        return function.evaluate(parameters, this.problemsHandler, input, evaluatedParameter);
    }

    static {
        FUNCTIONS.put(COLOR, new Color());
        FUNCTIONS.put(UNIT, new Unit());
        FUNCTIONS.put(CONVERT, new Convert());
        FUNCTIONS.put(EXTRACT, new Extract());
    }
}

