/*
 * Decompiled with CFR 0.152.
 */
package com.github.slavaz.maven.plugin.postgresql.embedded.psql;

import com.github.slavaz.maven.plugin.postgresql.embedded.psql.IPgInstanceProcessData;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.PgInstanceManager;
import com.github.slavaz.maven.plugin.postgresql.embedded.psql.data.PgInstanceProcessData;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class IsolatedPgInstanceManager {
    private final ClassLoader classLoader;

    public IsolatedPgInstanceManager(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void start(IPgInstanceProcessData data) throws IOException {
        Thread postgresThread = new Thread(() -> {
            Method startPostgres = this.getMethod("startPostgres", String.class, String.class, Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class);
            IsolatedPgInstanceManager.invokeStaticMethod(startPostgres, data.getPgServerVersion(), data.getPgHost(), data.getPgPort(), data.getDbName(), data.getUserName(), data.getPassword(), data.getPgDatabaseDir(), data.getPgLocale(), data.getPgCharset());
        }, "postgres-embedded");
        postgresThread.setContextClassLoader(this.classLoader);
        postgresThread.start();
        try {
            postgresThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Embedded Postgres thread was interrupted", e);
        }
    }

    public void stop() {
        IsolatedPgInstanceManager.invokeStaticMethod(this.getMethod("stopPostgres", new Class[0]), new Object[0]);
    }

    public static void startPostgres(String pgServerVersion, String pgHost, int pgPort, String dbName, String userName, String password, String pgDatabaseDir, String pgLocale, String pgCharset) throws IOException {
        PgInstanceManager.start(new PgInstanceProcessData(pgServerVersion, pgHost, pgPort, dbName, userName, password, pgDatabaseDir, pgLocale, pgCharset));
    }

    public static void stopPostgres() throws InterruptedException {
        PgInstanceManager.stop();
    }

    private Method getMethod(String methodName, Class<?> ... parameterTypes) {
        Class managerClass = this.loadClass(IsolatedPgInstanceManager.class.getName());
        try {
            return managerClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No method " + methodName + " on " + managerClass, e);
        }
    }

    private Class loadClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found: " + className, e);
        }
    }

    private static void invokeStaticMethod(Method m, Object ... arguments) {
        try {
            m.invoke(null, arguments);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Method " + m.getName() + " not accessible", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invocation of method " + m.getName() + " threw exception", e);
        }
    }
}

