/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.utils;

import com.github.approval.reporters.ExecutableDifferenceReporter;
import com.github.approval.utils.CrossPlatformCommand;
import java.io.IOException;

public class ExecutableExistsOnPath
extends CrossPlatformCommand<Boolean> {
    private final String executable;

    public ExecutableExistsOnPath(String executable) {
        this.executable = executable;
    }

    @Override
    protected Boolean onWindows() {
        try {
            return ExecutableDifferenceReporter.runProcess("where " + this.executable).waitFor() == 0;
        }
        catch (InterruptedException e) {
            return Boolean.FALSE;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }

    @Override
    protected Boolean onUnix() {
        try {
            return ExecutableDifferenceReporter.runProcess("/bin/sh", "-c", "type " + this.executable).waitFor() == 0;
        }
        catch (InterruptedException e) {
            return Boolean.FALSE;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }
}

