/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.reporters;

import com.github.approval.Reporter;
import com.github.approval.utils.DefaultFileSystemUtils;
import com.github.approval.utils.FileSystemUtils;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.swing.JOptionPane;

public class SwingInteractiveReporter
implements Reporter {
    private final Reporter other;
    private FileSystemUtils fileSystemReadWriter;

    SwingInteractiveReporter(Reporter other, FileSystemUtils fileSystemReadWriter) {
        this.other = other;
        this.fileSystemReadWriter = fileSystemReadWriter;
    }

    public static SwingInteractiveReporter wrap(Reporter reporter) {
        return new SwingInteractiveReporter(reporter, new DefaultFileSystemUtils());
    }

    @Override
    public void notTheSame(byte[] oldValue, File fileForVerification, byte[] newValue, File fileForApproval) {
        this.other.notTheSame(oldValue, fileForVerification, newValue, fileForApproval);
        this.interactWithUser(fileForApproval.toPath(), fileForVerification.toPath());
    }

    @Override
    public void approveNew(byte[] value, File fileForApproval, File fileForVerification) {
        this.other.approveNew(value, fileForApproval, fileForVerification);
        this.interactWithUser(fileForApproval.toPath(), fileForVerification.toPath());
    }

    private void interactWithUser(Path approvalPath, Path filePath) {
        if (this.isHeadless()) {
            throw new AssertionError((Object)"Cannot approve the new value in headless mode!");
        }
        int wasTheResultOK = this.promptUser();
        if (wasTheResultOK == 0) {
            try {
                this.fileSystemReadWriter.move(approvalPath, filePath);
            }
            catch (IOException e) {
                String errorMessage = String.format("Couldn't move file for approval[%s] to the destination [%s]", approvalPath.toAbsolutePath(), filePath.toAbsolutePath());
                throw new AssertionError(errorMessage, e);
            }
        } else {
            throw new AssertionError((Object)"Result was NOT OK");
        }
    }

    boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    int promptUser() {
        Object[] options = new Object[]{"OK", "NOT OK"};
        return JOptionPane.showOptionDialog(null, "Was the result correct", "Was the result correct", -1, 2, null, options, options[0]);
    }

    @Override
    public boolean canApprove(File fileForApproval) {
        return this.other.canApprove(fileForApproval);
    }
}

