/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.reporters;

import com.github.approval.Reporter;
import com.github.approval.reporters.ExecutableDifferenceReporter;
import com.github.approval.reporters.FirstWorkingReporter;
import com.github.approval.reporters.SwingInteractiveReporter;
import com.github.approval.utils.CrossPlatformCommand;
import com.github.approval.utils.ExecutableExistsOnPath;
import java.io.File;
import java.io.IOException;

public final class Reporters {
    private static final Reporter VIM_INSTANCE = new ExecutableDifferenceReporter("gvimdiff -f", "gvimdiff -f", "gvimdiff");
    private static final Reporter GEDIT = SwingInteractiveReporter.wrap(new ExecutableDifferenceReporter("gedit -w", "gedit -w", "gedit"){

        @Override
        protected String[] buildApproveNewCommand(File approvalDestination, File fileForVerification) {
            return new String[]{this.getApprovalCommand(), approvalDestination.getAbsolutePath()};
        }
    });
    private static final Reporter CONSOLE_REPORTER_INSTANCE = SwingInteractiveReporter.wrap(new ExecutableDifferenceReporter("cat", "diff -u", "cat"){

        @Override
        protected String[] buildApproveNewCommand(File approvalDestination, File fileForVerification) {
            return new String[]{this.getApprovalCommand(), approvalDestination.getAbsolutePath()};
        }

        @Override
        public boolean canApprove(File fileForApproval) {
            return super.canApprove(fileForApproval) && (Boolean)new ExecutableExistsOnPath("diff").execute() != false;
        }
    });

    private Reporters() {
    }

    public static Reporter gvim() {
        return VIM_INSTANCE;
    }

    public static Reporter console() {
        return CONSOLE_REPORTER_INSTANCE;
    }

    public static Reporter gedit() {
        return GEDIT;
    }

    public static Reporter fileLauncher() {
        return SwingInteractiveReporter.wrap(Reporters.fileLauncherWithoutInteraction());
    }

    public static Reporter fileLauncherWithoutInteraction() {
        String cmd = (String)new CrossPlatformCommand<String>(){

            @Override
            protected String onWindows() {
                return "cmd /C start";
            }

            @Override
            protected String onMac() {
                return "open";
            }

            @Override
            protected String onUnix() {
                return "xdg-open";
            }
        }.execute();
        return new ExecutableDifferenceReporter(cmd, cmd, null){

            @Override
            protected String[] buildApproveNewCommand(File approvalDestination, File fileForVerification) {
                return new String[]{this.getApprovalCommand(), approvalDestination.getAbsolutePath()};
            }

            @Override
            protected String[] buildNotTheSameCommand(File fileForVerification, File fileForApproval) {
                return new String[]{this.getDiffCommand(), fileForApproval.getAbsolutePath()};
            }
        };
    }

    public static Reporter imageMagick() {
        return SwingInteractiveReporter.wrap(new Reporter(){
            private final Reporter other = Reporters.fileLauncher();

            @Override
            public void notTheSame(byte[] oldValue, File fileForVerification, byte[] newValue, File fileForApproval) {
                try {
                    File compareResult = File.createTempFile("compareResult", fileForVerification.getName());
                    Process compare = ExecutableDifferenceReporter.runProcess("compare", fileForApproval.getCanonicalPath(), fileForVerification.getAbsolutePath(), compareResult.getAbsolutePath());
                    int result = compare.waitFor();
                    if (result != 0) {
                        throw new IllegalStateException("Couldn't execute compare!");
                    }
                    this.other.approveNew(newValue, compareResult, fileForVerification);
                }
                catch (IOException e) {
                    throw new AssertionError("Couldn't create file!", e);
                }
                catch (InterruptedException e) {
                    throw new AssertionError("Couldn't create file!", e);
                }
            }

            @Override
            public void approveNew(byte[] value, File fileForApproval, File fileForVerification) {
                this.other.approveNew(value, fileForApproval, fileForVerification);
            }

            @Override
            public boolean canApprove(File fileForApproval) {
                return this.other.canApprove(fileForApproval);
            }
        });
    }

    public static Reporter firstWorking(Reporter ... others) {
        return new FirstWorkingReporter(others);
    }
}

