/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.reporters;

import com.github.approval.Reporter;
import java.io.File;

class FirstWorkingReporter
implements Reporter {
    private final Reporter[] others;

    FirstWorkingReporter(Reporter ... others) {
        this.others = others;
    }

    @Override
    public void notTheSame(byte[] oldValue, File fileForVerification, byte[] newValue, File fileForApproval) {
        for (Reporter other : this.others) {
            if (!other.canApprove(fileForApproval)) continue;
            other.notTheSame(oldValue, fileForVerification, newValue, fileForApproval);
            return;
        }
        throw new IllegalStateException("This should never happen. Can approve was not called?!");
    }

    @Override
    public void approveNew(byte[] value, File fileForApproval, File fileForVerification) {
        for (Reporter other : this.others) {
            if (!other.canApprove(fileForApproval)) continue;
            other.approveNew(value, fileForVerification, fileForApproval);
            return;
        }
        throw new IllegalStateException("This should never happen. Can approve was not called?!");
    }

    @Override
    public boolean canApprove(File fileForApproval) {
        for (Reporter other : this.others) {
            if (!other.canApprove(fileForApproval)) continue;
            return true;
        }
        return false;
    }
}

