/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval.reporters;

import com.github.approval.Reporter;
import com.github.approval.utils.ExecutableExistsOnPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class ExecutableDifferenceReporter
implements Reporter {
    private final String diffCommand;
    private final String approvalCommand;
    private final String executable;

    public ExecutableDifferenceReporter(String approvalCommand, String diffCommand, @Nullable String executable) {
        this.approvalCommand = approvalCommand;
        this.diffCommand = diffCommand;
        this.executable = executable;
    }

    protected String getDiffCommand() {
        return this.diffCommand;
    }

    protected String getApprovalCommand() {
        return this.approvalCommand;
    }

    @Override
    public void notTheSame(byte[] oldValue, File fileForVerification, byte[] newValue, File fileForApproval) {
        try {
            this.execute(this.buildNotTheSameCommand(fileForVerification, fileForApproval));
        }
        catch (IOException e) {
            throw new AssertionError("There was a problem while executing %s", e);
        }
    }

    protected String[] buildNotTheSameCommand(File fileForVerification, File fileForApproval) {
        return new String[]{this.diffCommand, fileForApproval.getAbsolutePath(), fileForVerification.getAbsolutePath()};
    }

    @Override
    public void approveNew(byte[] value, File approvalDestination, File fileForVerification) {
        try {
            int processExit = this.execute(this.buildApproveNewCommand(approvalDestination, fileForVerification));
            if (processExit != 0) {
                throw new AssertionError((Object)String.format("Command %s returned an error exit code!", this.approvalCommand));
            }
        }
        catch (IOException e) {
            throw new AssertionError(String.format("There was a problem while executing %s", this.approvalCommand), e);
        }
    }

    protected String[] buildApproveNewCommand(File approvalDestination, File fileForVerification) {
        return new String[]{this.approvalCommand, approvalDestination.getAbsolutePath(), fileForVerification.getAbsolutePath()};
    }

    @Override
    public boolean canApprove(File fileForApproval) {
        if (this.executable != null) {
            return (Boolean)new ExecutableExistsOnPath(this.executable).execute();
        }
        return true;
    }

    private int execute(String ... cmdParts) throws IOException {
        Process process = this.startProcess(cmdParts);
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new AssertionError("Thread was interrupted while waiting for process to finish", e);
        }
    }

    Process startProcess(String ... cmdParts) throws IOException {
        return ExecutableDifferenceReporter.runProcess(cmdParts);
    }

    public static Process runProcess(String ... cmdParts) throws IOException {
        return new ProcessBuilder(ExecutableDifferenceReporter.buildCommandline(cmdParts)).inheritIO().start();
    }

    static List<String> buildCommandline(String ... cmdParts) {
        ArrayList<String> cmd = new ArrayList<String>();
        String[] cmdFromUser = cmdParts[0].split("\\s+");
        Collections.addAll(cmd, cmdFromUser);
        cmd.addAll(Arrays.asList(cmdParts).subList(1, cmdParts.length));
        return cmd;
    }
}

