/*
 * Decompiled with CFR 0.152.
 */
package com.github.approval;

import com.github.approval.PathMapper;
import com.github.approval.Pre;
import com.github.approval.Reporter;
import com.github.approval.converters.Converter;
import com.github.approval.converters.Converters;
import com.github.approval.utils.DefaultFileSystemUtils;
import com.github.approval.utils.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Approval<T> {
    private static final Logger LOG = Logger.getLogger(Approval.class.getName());
    private static final String FOR_APPROVAL_EXTENSION = ".forapproval";
    private final Reporter reporter;
    private final FileSystemUtils fileSystemReadWriter;
    private final Converter<T> converter;
    private PathMapper<T> pathMapper;

    Approval(Reporter reporter, Converter<T> converter, @Nullable PathMapper<T> pathMapper) {
        this(reporter, converter, pathMapper, new DefaultFileSystemUtils());
    }

    Approval(Reporter reporter, Converter<T> converter, @Nullable PathMapper<T> pathMapper, FileSystemUtils fileSystemReadWriter) {
        this.fileSystemReadWriter = fileSystemReadWriter;
        this.converter = converter;
        this.reporter = reporter;
        this.pathMapper = pathMapper;
    }

    @Nonnull
    public static <T> ApprovalBuilder<T> of(Class<T> clazz) {
        return new ApprovalBuilder(clazz);
    }

    @Nonnull
    public static Path getApprovalPath(Path filePath) {
        Pre.notNull(filePath, "filePath");
        String s = filePath.toString();
        int extensionIndex = s.lastIndexOf(46);
        if (extensionIndex == -1) {
            return Paths.get(s + FOR_APPROVAL_EXTENSION, new String[0]);
        }
        int lastPartOfPath = s.lastIndexOf(47);
        if (lastPartOfPath != -1 && lastPartOfPath > extensionIndex) {
            return Paths.get(s + FOR_APPROVAL_EXTENSION, new String[0]);
        }
        String firstPart = s.substring(0, extensionIndex);
        String extension = s.substring(extensionIndex);
        return Paths.get(firstPart + FOR_APPROVAL_EXTENSION + extension, new String[0]);
    }

    private static <T> Converter<T> getConverterForPrimitive(Class<T> clazz) {
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return Converters.BYTE;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return Converters.INTEGER;
        }
        if (clazz.equals(String.class)) {
            return Converters.STRING;
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return Converters.SHORT;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return Converters.LONG;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return Converters.BOOLEAN;
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Converters.FLOAT;
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return Converters.DOUBLE;
        }
        if (clazz.equals(Character.class) || clazz.equals(Character.TYPE)) {
            return Converters.CHAR;
        }
        if (clazz.equals(byte[].class)) {
            return Converters.BYTE_ARRAY;
        }
        if (clazz.equals(int[].class)) {
            return Converters.INTEGER_ARRAY;
        }
        if (clazz.equals(short[].class)) {
            return Converters.SHORT_ARRAY;
        }
        if (clazz.equals(long[].class)) {
            return Converters.LONG_ARRAY;
        }
        if (clazz.equals(float[].class)) {
            return Converters.FLOAT_ARRAY;
        }
        if (clazz.equals(double[].class)) {
            return Converters.DOUBLE_ARRAY;
        }
        if (clazz.equals(boolean[].class)) {
            return Converters.BOOLEAN_ARRAY;
        }
        if (clazz.equals(char[].class)) {
            return Converters.CHAR_ARRAY;
        }
        if (clazz.equals(String[].class)) {
            return Converters.STRING_ARRAY;
        }
        throw new IllegalArgumentException(clazz + " is not a primitive type class!");
    }

    @Nonnull
    Converter<T> getConverter() {
        return this.converter;
    }

    @Nonnull
    Reporter getReporter() {
        return this.reporter;
    }

    public void verify(@Nullable T value, Path filePath) {
        block9: {
            Pre.notNull(filePath, "filePath");
            File file = this.mapFilePath(value, filePath);
            File parentPathDirectory = file.getParentFile();
            if (parentPathDirectory != null && !parentPathDirectory.exists()) {
                try {
                    this.fileSystemReadWriter.createDirectories(parentPathDirectory);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            Path approvalPath = Approval.getApprovalPath(file.toPath());
            byte[] rawValue = this.converter.getRawForm(value);
            if (!file.exists()) {
                LOG.info(file + " didn't exist. You will be asked for approval");
                this.handleFirstTimeApproval(file, approvalPath, rawValue);
                return;
            }
            boolean wasAbleSetModified = file.setLastModified(System.currentTimeMillis());
            if (!wasAbleSetModified) {
                LOG.warning("We weren't able to change the modification date for " + file.getAbsolutePath());
            }
            try {
                byte[] fileContent = this.fileSystemReadWriter.readFully(file.toPath());
                if (Arrays.equals(fileContent, rawValue)) break block9;
                try {
                    LOG.info("Approval in " + file + " is not the same as the last value. You will be asked for approval of the new value.");
                    this.fileSystemReadWriter.write(approvalPath, rawValue);
                }
                catch (IOException e) {
                    throw new AssertionError("Couldn't write the new approval file " + file, e);
                }
                this.reporter.notTheSame(fileContent, file, rawValue, approvalPath.toFile());
            }
            catch (IOException e) {
                throw new AssertionError("Couldn't read the previous content in file " + file, e);
            }
        }
    }

    private void handleFirstTimeApproval(File file, Path approvalPath, byte[] rawValue) {
        try {
            this.fileSystemReadWriter.write(approvalPath, rawValue);
            approvalPath.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new AssertionError("Couldn't write path for approval " + approvalPath, e);
        }
        Path path = file.toPath();
        try {
            this.fileSystemReadWriter.touch(path);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)("Couldn't create path " + path));
        }
        this.reporter.approveNew(rawValue, approvalPath.toFile(), file);
    }

    private File mapFilePath(@Nullable T value, Path filePath) {
        File file = this.pathMapper != null ? this.pathMapper.getPath(value, filePath).toFile() : filePath.toFile();
        return file;
    }

    PathMapper<T> getPathMapper() {
        return this.pathMapper;
    }

    public static final class ApprovalBuilder<T> {
        private final Class<T> clazz;
        private Converter<T> converter;
        private Reporter reporter;
        private PathMapper<T> pathMapper;

        private ApprovalBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Nonnull
        public ApprovalBuilder<T> withConveter(Converter<T> converterToBeUsed) {
            Pre.notNull(converterToBeUsed, "converter");
            this.converter = converterToBeUsed;
            return this;
        }

        @Nonnull
        public ApprovalBuilder<T> withPathMapper(PathMapper<T> pathMapperToBeUsed) {
            Pre.notNull(pathMapperToBeUsed, "pathMapper");
            this.pathMapper = pathMapperToBeUsed;
            return this;
        }

        @Nonnull
        public Approval<T> build() {
            if (this.converter == null) {
                try {
                    this.converter = Approval.getConverterForPrimitive(this.clazz);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException(String.format("You didn't provide a converter for %s and it is not a primitive type!", this.clazz));
                }
            }
            if (this.reporter == null) {
                throw new IllegalStateException("You didn't provide a reporter!");
            }
            return new Approval<T>(this.reporter, this.converter, this.pathMapper);
        }

        public ApprovalBuilder<T> withReporter(Reporter reporterToBeUsed) {
            Pre.notNull(reporterToBeUsed, "reporter");
            this.reporter = reporterToBeUsed;
            return this;
        }
    }
}

