/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.apple;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class PropertyListSerialization {
    private PropertyListSerialization() {
    }

    public static void serialize(Map propertyList, List comments, File file) throws IOException, SAXException, TransformerConfigurationException {
        SAXTransformerFactory sf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = sf.newTransformerHandler();
        FileOutputStream os = new FileOutputStream(file);
        StreamResult result = new StreamResult(os);
        handler.setResult(result);
        handler.startDocument();
        Iterator iter = comments.iterator();
        while (iter.hasNext()) {
            char[] comment = String.valueOf(iter.next()).toCharArray();
            handler.comment(comment, 0, comment.length);
        }
        AttributesImpl attributes = new AttributesImpl();
        handler.startElement(null, "plist", "plist", attributes);
        PropertyListSerialization.serializeMap(propertyList, handler);
        handler.endElement(null, "plist", "plist");
        handler.endDocument();
    }

    private static void serializeMap(Map map, ContentHandler handler) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        handler.startElement(null, "dict", "dict", attributes);
        if (map.size() > 0) {
            Object[] keys = map.keySet().toArray();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                String key = String.valueOf(keys[i]);
                handler.startElement(null, "key", "key", attributes);
                handler.characters(key.toCharArray(), 0, key.length());
                handler.endElement(null, "key", "key");
                PropertyListSerialization.serializeObject(map.get(keys[i]), handler);
            }
        }
        handler.endElement(null, "dict", "dict");
    }

    private static void serializeList(List list, ContentHandler handler) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        handler.startElement(null, "array", "array", attributes);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            PropertyListSerialization.serializeObject(iter.next(), handler);
        }
        handler.endElement(null, "array", "array");
    }

    private static void serializeElement(String tag, String content, ContentHandler handler) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        handler.startElement(null, tag, tag, attributes);
        handler.characters(content.toCharArray(), 0, content.length());
        handler.endElement(null, tag, tag);
    }

    private static void serializeInteger(Number integer, ContentHandler handler) throws SAXException {
        PropertyListSerialization.serializeElement("integer", String.valueOf(integer.longValue()), handler);
    }

    private static void serializeReal(Number real, ContentHandler handler) throws SAXException {
        PropertyListSerialization.serializeElement("real", String.valueOf(real.doubleValue()), handler);
    }

    private static void serializeBoolean(Boolean val, ContentHandler handler) throws SAXException {
        String tag = "false";
        if (val.booleanValue()) {
            tag = "true";
        }
        AttributesImpl attributes = new AttributesImpl();
        handler.startElement(null, tag, tag, attributes);
        handler.endElement(null, tag, tag);
    }

    private static void serializeString(String val, ContentHandler handler) throws SAXException {
        PropertyListSerialization.serializeElement("string", val, handler);
    }

    private static void serializeObject(Object obj, ContentHandler handler) throws SAXException {
        if (obj instanceof Map) {
            PropertyListSerialization.serializeMap((Map)obj, handler);
        } else if (obj instanceof List) {
            PropertyListSerialization.serializeList((List)obj, handler);
        } else if (obj instanceof Number) {
            if (obj instanceof Double || obj instanceof Float) {
                PropertyListSerialization.serializeReal((Number)obj, handler);
            } else {
                PropertyListSerialization.serializeInteger((Number)obj, handler);
            }
        } else if (obj instanceof Boolean) {
            PropertyListSerialization.serializeBoolean((Boolean)obj, handler);
        } else {
            PropertyListSerialization.serializeString(String.valueOf(obj), handler);
        }
    }
}

