/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.NarUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.PropertyUtils;

public class NarProperties {
    private static final String AOL_PROPERTIES = "aol.properties";
    private static final String CUSTOM_AOL_PROPERTY_KEY = "nar.aolProperties";
    private Properties properties;
    private static NarProperties instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NarProperties(MavenProject project) throws MojoFailureException {
        Properties defaults = PropertyUtils.loadProperties((InputStream)NarUtil.class.getResourceAsStream(AOL_PROPERTIES));
        if (defaults == null) {
            throw new MojoFailureException("NAR: Could not load default properties file: 'aol.properties'.");
        }
        this.properties = new Properties(defaults);
        FileInputStream fis = null;
        String customPropertyLocation = null;
        try {
            if (project != null) {
                customPropertyLocation = project.getProperties().getProperty(CUSTOM_AOL_PROPERTY_KEY);
                if (customPropertyLocation == null) {
                    customPropertyLocation = System.getProperties().getProperty(CUSTOM_AOL_PROPERTY_KEY);
                }
                fis = new FileInputStream(customPropertyLocation != null ? customPropertyLocation : project.getBasedir() + File.separator + AOL_PROPERTIES);
                this.properties.load(fis);
            }
        }
        catch (FileNotFoundException e) {
            if (customPropertyLocation != null) {
                throw new MojoFailureException("NAR: Could not load custom properties file: '" + customPropertyLocation + "'.");
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static NarProperties getInstance(MavenProject project) throws MojoFailureException {
        if (instance == null) {
            instance = new NarProperties(project);
        }
        return instance;
    }

    public static void inject(MavenProject project, InputStream properties) throws MojoFailureException {
        Properties defaults = PropertyUtils.loadProperties((InputStream)properties);
        NarProperties nar = NarProperties.getInstance(project);
        nar.properties.putAll((Map<?, ?>)defaults);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }
}

