package com.github.markzhai.uiframework;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.ListView;

import com.github.markzhai.uiframework.helper.DataListFooterViewHelper;
import com.github.markzhai.uiframework.helper.StateViewHelper;
import com.github.markzhai.uikit.DataListFooterView;
import com.github.markzhai.uikit.StateView;
import com.github.markzhai.uikit.StateView.State;

import java.util.List;

/**
 * @author markzhai on 16/2/28
 * @version 1.0.0
 */
public abstract class PageDataLoadingFragment<MODEL> extends BaseFragment implements PageDataLoadingView<MODEL> {
    private DataListFooterView mDataListFooterView;
    private ListView mInjectListView;
    private LayoutInflater mLayoutInflater;
    private StateView mStateView;

    protected abstract LifeCircle getPresenter();

    protected abstract View onCreateSuccessView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle);

    protected abstract void onRetryClick();

    public final View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        mLayoutInflater = inflater;
        mStateView = new StateViewHelper().inject(
                onCreateSuccessView(inflater, container, savedInstanceState),
                v -> PageDataLoadingFragment.this.onRetryClick());
        return mStateView;
    }

    protected LayoutInflater getLayoutInflater() {
        return this.mLayoutInflater;
    }

    public void onResume() {
        super.onResume();
        getPresenter().resume();
    }

    public void onPause() {
        super.onPause();
        getPresenter().pause();
    }

    public void onDestroy() {
        super.onDestroy();
        getPresenter().destroy();
    }

    public void showLoading() {
        this.mStateView.setState(State.LOADING);
    }

    public void showFailure(String message) {
        this.mStateView.setState(State.FAILED);
    }

    public void showNoData() {
        this.mStateView.setState(State.NO_DATA);
    }

    public void showSuccess() {
        this.mStateView.setState(State.SUCCESS);
    }

    public void setData(MODEL model) {
    }

    public void setData(List<MODEL> list) {
    }

    public void appendData(List<MODEL> list) {
    }

    public void showNextPageLoading() {
        if (mDataListFooterView != null) {
            mDataListFooterView.showLoadingAnim();
        }
    }

    public void showNextPageFailure() {
        if (mDataListFooterView != null) {
            mDataListFooterView.showLoadFailText();
        }
    }

    public void showNextPageSuccess() {
        if (mDataListFooterView != null) {
            mDataListFooterView.hide();
        }
    }

    public void showAllPageLoaded() {
        if (mDataListFooterView != null) {
            mDataListFooterView.showLastPageText("共" +
                    ((mInjectListView.getAdapter().getCount() -
                            mInjectListView.getFooterViewsCount()) -
                            mInjectListView.getHeaderViewsCount()) + "个");
        }
    }

    protected void addFooterLoadingViewToList(ListView injectListView,
                                              OnClickListener retryListener) {
        mInjectListView = injectListView;
        mDataListFooterView = new DataListFooterViewHelper()
                .inject(mInjectListView, retryListener);
        mInjectListView.addFooterView(mDataListFooterView);
    }
}