/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.services.js;

import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;
import org.got5.tapestry5.jquery.services.js.JSLocator;

public class JSLocatorSession
implements JSLocator {
    private final String prefix = "JS";
    private final Request request;

    public JSLocatorSession(Request request) {
        this.request = request;
    }

    public String store(String script) {
        Session session = this.request.getSession(true);
        String key = this.createKey(script);
        Integer max = 0;
        if (session.getAttribute(key) != null) {
            List names = session.getAttributeNames("JS");
            for (String name : names) {
                String[] parts = name.split("-");
                Integer seq = new Integer(parts[1]);
                if (seq <= max) continue;
                max = seq;
            }
        }
        String fkey = key + "-" + (max + 1);
        session.setAttribute(fkey, (Object)script);
        return this.keyToUrl(fkey);
    }

    public String find(String path) {
        Session session = this.request.getSession(true);
        String script = (String)session.getAttribute(path);
        session.setAttribute(path, null);
        return script;
    }

    private String createKey(String script) {
        return "JS" + new String(Hex.encodeHex((byte[])DigestUtils.sha((String)script)));
    }

    public String keyToUrl(String key) {
        return String.format("%s/js/%s", this.request.getContextPath(), key);
    }
}

