/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.utils.JQueryUtils;
import org.slf4j.Logger;

@Import(library={"${assets.path}/components/showSource/jquery.snippet.js", "${assets.path}/components/showSource/my-snippet.js"}, stylesheet={"${assets.path}/components/showSource/jquery.snippet.css"})
public class ShowSource {
    @Parameter(defaultPrefix="literal")
    private String path;
    @Parameter(defaultPrefix="prop")
    private JSONObject specs;
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(defaultPrefix="literal")
    private String ext;
    @Parameter(value="0")
    private Integer beginLine;
    @Parameter
    private Integer endLine;
    private JSONObject defaultSpecs;
    @Inject
    private AssetSource assetSource;
    @Inject
    private Logger logger;
    @Inject
    private JavaScriptSupport support;
    private Map<String, String> langs;
    @Inject
    @Symbol(value="demo-src-dir")
    private String srcDir;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private Messages message;

    private boolean setupRender() {
        if (!this.componentResources.isBound("path")) {
            this.logger.warn("We have to specify a path for the showSource component");
            return false;
        }
        if (this.componentResources.isBound("endLine") && this.endLine < this.beginLine) {
            this.logger.warn("The endLine parameter has to be greater than beginLine");
            return false;
        }
        this.defaultSpecs = new JSONObject();
        System.out.println("########### " + this.path.substring(this.path.lastIndexOf("/") + 1));
        this.defaultSpecs.put("showMsg", (Object)(this.path.substring(this.path.lastIndexOf("/") + 1) + " - " + this.message.get("ShowSource-showMsg")));
        this.defaultSpecs.put("hideMsg", (Object)(this.path.substring(this.path.lastIndexOf("/") + 1) + " - " + this.message.get("ShowSource-hideMsg")));
        this.defaultSpecs.put("style", (Object)this.message.get("ShowSource-style"));
        this.defaultSpecs.put("collapse", (Object)this.message.get("ShowSource-collapse"));
        this.defaultSpecs.put("showNum", (Object)this.message.get("ShowSource-showNum"));
        this.defaultSpecs.put("clipboard", (Object)this.assetSource.getUnlocalizedAsset("org/got5/tapestry5/jquery/assets/components/showSource/my-snippet.js").toClientURL());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSrcContent() {
        StringBuffer buffer = new StringBuffer();
        FileInputStream is = null;
        File file = null;
        String rootSrc = InternalUtils.isBlank((String)this.srcDir) ? System.getProperty("user.dir") + "/src/test/" : this.srcDir;
        String pathFile = rootSrc + File.separator + this.path;
        this.logger.info("The ShowSource Component displays the file : " + pathFile);
        file = new File(pathFile);
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfEx) {
            this.logger.error("Error file.");
        }
        if (is != null) {
            try {
                Integer numLine = 1;
                BufferedReader buffReader = new BufferedReader(new InputStreamReader(is));
                String line = buffReader.readLine();
                while (line != null) {
                    if (numLine >= this.beginLine) {
                        if (this.componentResources.isBound("endLine") && numLine > this.endLine) break;
                        buffer.append(new String(new byte[]{13}));
                        buffer.append(line);
                    }
                    Integer n = numLine;
                    Integer n2 = numLine = Integer.valueOf(numLine + 1);
                    line = buffReader.readLine();
                }
                buffReader.close();
            }
            catch (IOException ioEx) {
                buffer.append(ioEx.getMessage());
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception ioEx) {
                        this.logger.error("Error closing the Asset");
                    }
                }
            }
        }
        return buffer.toString();
    }

    public void afterRender() {
        JSONObject params = new JSONObject();
        params.put("id", (Object)this.getClientId());
        params.put("lang", (Object)this.getLanguage());
        params.put("beginLine", (Object)this.beginLine);
        JQueryUtils.merge(this.defaultSpecs, this.specs);
        this.defaultSpecs.put("collapse", (Object)Boolean.parseBoolean(this.defaultSpecs.getString("collapse")));
        this.defaultSpecs.put("showNum", (Object)Boolean.parseBoolean(this.defaultSpecs.getString("showNum")));
        JQueryUtils.merge(params, this.defaultSpecs);
        this.support.addInitializerCall("source", params);
    }

    public String getLanguage() {
        if (this.componentResources.isBound("ext")) {
            return this.ext;
        }
        this.langs = new HashMap<String, String>();
        this.langs.put("js", "javascript");
        this.langs.put("tml", "html");
        String extension = this.path.substring(this.path.lastIndexOf(46) + 1);
        extension = this.langs.get(extension) != null ? this.langs.get(extension) : extension;
        return extension;
    }

    public String getClientId() {
        return this.clientId;
    }
}

