/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidationSupport;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.SelectModelVisitor;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.ValidationTracker;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.base.AbstractField;
import org.apache.tapestry5.internal.util.SelectModelRenderer;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.ComponentDefaultProvider;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.got5.tapestry5.jquery.ImportJQueryUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ImportJQueryUI(value={"jquery.ui.widget"})
@Import(library={"${assets.path}/components/palette/palette.js"})
public class Palette
extends AbstractField {
    private List<Runnable> availableOptions;
    @Parameter(value="asset:deselect.png")
    @Property(write=false)
    private Asset deselect;
    @Parameter(required=true, allowNull=false)
    private ValueEncoder<Object> encoder;
    @Parameter(required=true, allowNull=false)
    private SelectModel model;
    @Property(write=false)
    @Parameter(required=true, allowNull=false, value="message:available-label", defaultPrefix="literal")
    private Block availableLabel;
    @Property(write=false)
    @Parameter(required=true, allowNull=false, value="message:selected-label", defaultPrefix="literal")
    private Block selectedLabel;
    @Parameter(value="asset:move_down.png")
    @Property(write=false)
    private Asset moveDown;
    @Parameter(value="asset:move_up.png")
    @Property(write=false)
    private Asset moveUp;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Environmental
    private ValidationTracker tracker;
    @Inject
    private Request request;
    @Inject
    private ComponentDefaultProvider defaultProvider;
    @Inject
    private ComponentResources componentResources;
    @Inject
    private FieldValidationSupport fieldValidationSupport;
    private SelectModelRenderer renderer;
    @Parameter(value="asset:select.png")
    @Property(write=false)
    private Asset select;
    @Parameter(required=true, autoconnect=true)
    private List<Object> selected;
    @Parameter(value="false")
    @Property(write=false)
    private boolean reorder;
    private List<OptionModel> selectedOptions;
    private Map<Object, OptionModel> valueToOptionModel;
    @Parameter(value="10")
    private int size;
    @Parameter(defaultPrefix="validate")
    private FieldValidator<Object> validate;
    @Inject
    @Symbol(value="tapestry.compact-json")
    private boolean compactJSON;
    private List<String> naturalOrder;

    public Renderable getAvailableRenderer() {
        return new AvailableRenderer();
    }

    public Renderable getSelectedRenderer() {
        return new SelectedRenderer();
    }

    protected void processSubmission(String controlName) {
        String parameterValue = this.request.getParameter(controlName + "-values");
        this.tracker.recordInput((Field)this, parameterValue);
        JSONArray values = new JSONArray(parameterValue);
        List selected = this.selected;
        if (selected == null) {
            selected = CollectionFactory.newList();
        } else {
            selected.clear();
        }
        ValueEncoder<Object> encoder = this.encoder;
        int count = values.length();
        for (int i = 0; i < count; ++i) {
            String value = values.getString(i);
            Object objectValue = encoder.toValue(value);
            selected.add(objectValue);
        }
        this.putPropertyNameIntoBeanValidationContext("selected");
        try {
            this.fieldValidationSupport.validate((Object)selected, this.componentResources, this.validate);
            this.selected = selected;
        }
        catch (ValidationException e) {
            this.tracker.recordError((Field)this, e.getMessage());
        }
        this.removePropertyNameFromBeanValidationContext();
    }

    private void writeDisabled(MarkupWriter writer, boolean disabled) {
        if (disabled) {
            writer.attributes(new Object[]{"disabled", "disabled"});
        }
    }

    void beginRender(MarkupWriter writer) {
        JSONArray selectedValues = new JSONArray();
        for (OptionModel selected : this.selectedOptions) {
            Object object = selected.getValue();
            String clientValue = this.encoder.toClient(object);
            selectedValues.put((Object)clientValue);
        }
        JSONArray naturalOrder = new JSONArray();
        for (String string : this.naturalOrder) {
            naturalOrder.put((Object)string);
        }
        String clientId = this.getClientId();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", (Object)clientId);
        jSONObject.put("reorder", (Object)this.reorder);
        jSONObject.put("naturalOrder", (Object)naturalOrder);
        this.javascriptSupport.addInitializerCall("palette", jSONObject);
        writer.element("input", new Object[]{"type", "hidden", "id", clientId + "-values", "name", this.getControlName() + "-values", "value", selectedValues});
        writer.end();
    }

    boolean beforeRenderBody() {
        return false;
    }

    void setupRender(MarkupWriter writer) {
        this.valueToOptionModel = CollectionFactory.newMap();
        this.availableOptions = CollectionFactory.newList();
        this.selectedOptions = CollectionFactory.newList();
        this.naturalOrder = CollectionFactory.newList();
        this.renderer = new SelectModelRenderer(writer, this.encoder);
        final Set selectedSet = CollectionFactory.newSet(this.getSelected());
        SelectModelVisitor visitor = new SelectModelVisitor(){

            public void beginOptionGroup(OptionGroupModel groupModel) {
                Palette.this.availableOptions.add(new OptionGroupStart(groupModel));
            }

            public void endOptionGroup(OptionGroupModel groupModel) {
                Palette.this.availableOptions.add(new OptionGroupEnd(groupModel));
            }

            public void option(OptionModel optionModel) {
                Object value = optionModel.getValue();
                boolean isSelected = selectedSet.contains(value);
                String clientValue = Palette.this.toClient(value);
                Palette.this.naturalOrder.add(clientValue);
                if (isSelected) {
                    Palette.this.selectedOptions.add(optionModel);
                    Palette.this.valueToOptionModel.put(value, optionModel);
                    return;
                }
                Palette.this.availableOptions.add(new RenderOption(optionModel));
            }
        };
        this.model.visit(visitor);
    }

    Binding defaultValidate() {
        return this.defaultProvider.defaultValidatorBinding("selected", this.componentResources);
    }

    int getSize() {
        return this.size;
    }

    String toClient(Object value) {
        return this.encoder.toClient(value);
    }

    List<Object> getSelected() {
        if (this.selected == null) {
            return Collections.emptyList();
        }
        return this.selected;
    }

    public boolean isRequired() {
        return this.validate.isRequired();
    }

    private final class SelectedRenderer
    implements Renderable {
        private SelectedRenderer() {
        }

        public void render(MarkupWriter writer) {
            writer.element("select", new Object[]{"id", Palette.this.getClientId(), "multiple", "multiple", "size", Palette.this.getSize(), "name", Palette.this.getControlName()});
            Palette.this.writeDisabled(writer, Palette.this.isDisabled());
            Palette.this.putPropertyNameIntoBeanValidationContext("selected");
            Palette.this.validate.render(writer);
            Palette.this.removePropertyNameFromBeanValidationContext();
            for (Object value : Palette.this.getSelected()) {
                OptionModel model = (OptionModel)Palette.this.valueToOptionModel.get(value);
                Palette.this.renderer.option(model);
            }
            writer.end();
        }
    }

    private final class RenderOption
    implements Runnable {
        private final OptionModel model;

        private RenderOption(OptionModel model) {
            this.model = model;
        }

        public void run() {
            Palette.this.renderer.option(this.model);
        }
    }

    private final class OptionGroupStart
    implements Runnable {
        private final OptionGroupModel model;

        private OptionGroupStart(OptionGroupModel model) {
            this.model = model;
        }

        public void run() {
            Palette.this.renderer.beginOptionGroup(this.model);
        }
    }

    private final class OptionGroupEnd
    implements Runnable {
        private final OptionGroupModel model;

        private OptionGroupEnd(OptionGroupModel model) {
            this.model = model;
        }

        public void run() {
            Palette.this.renderer.endOptionGroup(this.model);
        }
    }

    private final class AvailableRenderer
    implements Renderable {
        private AvailableRenderer() {
        }

        public void render(MarkupWriter writer) {
            writer.element("select", new Object[]{"id", Palette.this.getClientId() + "-avail", "multiple", "multiple", "size", Palette.this.getSize(), "name", Palette.this.getControlName() + "-avail"});
            Palette.this.writeDisabled(writer, Palette.this.isDisabled());
            for (Runnable r : Palette.this.availableOptions) {
                r.run();
            }
            writer.end();
        }
    }
}

