/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.ObjectParameterInfo;
import com.kenai.jffi.ObjectParameterStrategy;
import com.kenai.jffi.Platform;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.NativeLong;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Struct;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.jffi.AbstractAsmLibraryInterface;
import jnr.ffi.provider.jffi.AbstractFastNumericMethodGenerator;
import jnr.ffi.provider.jffi.AsmBuilder;
import jnr.ffi.provider.jffi.AsmUtil;
import jnr.ffi.provider.jffi.BaseMethodGenerator;
import jnr.ffi.provider.jffi.BufferMethodGenerator;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.LocalVariable;
import jnr.ffi.provider.jffi.LocalVariableAllocator;
import jnr.ffi.provider.jffi.MethodGenerator;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.PointerParameterStrategy;
import jnr.ffi.provider.jffi.ResultType;
import jnr.ffi.provider.jffi.SigType;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import jnr.ffi.provider.jffi.StubCompiler;
import org.objectweb.asm.Label;

class X86MethodGenerator
implements MethodGenerator {
    private final AtomicLong nextMethodID = new AtomicLong(0L);
    private final StubCompiler compiler;
    private final BufferMethodGenerator bufgen;

    X86MethodGenerator(StubCompiler compiler, BufferMethodGenerator bufgen) {
        this.compiler = compiler;
        this.bufgen = bufgen;
    }

    public boolean isSupported(ResultType resultType, ParameterType[] parameterTypes, CallingConvention callingConvention) {
        if (!Boolean.valueOf(System.getProperty("jnr.ffi.x86asm.enabled", "true")).booleanValue()) {
            return false;
        }
        Platform platform = Platform.getPlatform();
        if (platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform.getCPU().equals((Object)Platform.CPU.I386) && !platform.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        if (!callingConvention.equals((Object)CallingConvention.DEFAULT)) {
            return false;
        }
        int objectCount = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!X86MethodGenerator.isSupportedParameter(parameterTypes[i])) {
                return false;
            }
            if (!X86MethodGenerator.isSupportedObjectParameterType(parameterTypes[i])) continue;
            ++objectCount;
        }
        if (objectCount > 0 && (parameterTypes.length > 4 || objectCount > 3)) {
            return false;
        }
        return X86MethodGenerator.isSupportedResult(resultType) && this.compiler.canCompile(resultType, parameterTypes, callingConvention);
    }

    public void generate(AsmBuilder builder, String functionName, Function function, ResultType resultType, ParameterType[] parameterTypes, boolean ignoreError) {
        Class nativeReturnType;
        Class[] nativeParameterTypes = new Class[parameterTypes.length];
        boolean wrapperNeeded = false;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!parameterTypes[i].effectiveJavaType().isPrimitive()) {
                nativeParameterTypes[i] = X86MethodGenerator.getNativeClass(parameterTypes[i].nativeType);
                wrapperNeeded = true;
                continue;
            }
            nativeParameterTypes[i] = parameterTypes[i].effectiveJavaType();
        }
        if (resultType.effectiveJavaType().isPrimitive()) {
            nativeReturnType = resultType.effectiveJavaType();
        } else {
            nativeReturnType = X86MethodGenerator.getNativeClass(resultType.nativeType);
            wrapperNeeded = true;
        }
        String stubName = functionName + (wrapperNeeded ? "$jni$" + this.nextMethodID.incrementAndGet() : "");
        builder.getClassVisitor().visitMethod(0x111 | (wrapperNeeded ? 8 : 0), stubName, CodegenUtils.sig(nativeReturnType, nativeParameterTypes), null, null);
        this.compiler.compile(function, stubName, resultType, parameterTypes, nativeReturnType, nativeParameterTypes, CallingConvention.DEFAULT, !ignoreError);
        if (wrapperNeeded) {
            X86MethodGenerator.generateWrapper(builder, functionName, function, resultType, parameterTypes, stubName, nativeReturnType, nativeParameterTypes);
        }
    }

    private static void generateWrapper(AsmBuilder builder, String functionName, Function function, ResultType resultType, ParameterType[] parameterTypes, String nativeMethodName, Class nativeReturnType, Class[] nativeParameterTypes) {
        Class[] javaParameterTypes = new Class[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            javaParameterTypes[i] = parameterTypes[i].getDeclaredType();
        }
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(builder.getClassVisitor(), 17, functionName, CodegenUtils.sig(resultType.getDeclaredType(), javaParameterTypes), null, null);
        mv.setMethodVisitor(AsmUtil.newTraceMethodVisitor(mv.getMethodVisitor()));
        mv.start();
        LocalVariableAllocator localVariableAllocator = new LocalVariableAllocator(parameterTypes);
        LocalVariable objCount = localVariableAllocator.allocate(Integer.TYPE);
        LocalVariable[] parameters = AsmUtil.getParameterVariables(parameterTypes);
        LocalVariable[] pointers = new LocalVariable[parameterTypes.length];
        LocalVariable[] strategies = new LocalVariable[parameterTypes.length];
        LocalVariable[] converted = new LocalVariable[parameterTypes.length];
        int pointerCount = 0;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class javaParameterClass = parameterTypes[i].effectiveJavaType();
            Class nativeParameterClass = nativeParameterTypes[i];
            BaseMethodGenerator.loadAndConvertParameter(builder, mv, parameters[i], parameterTypes[i]);
            if (parameterTypes[i].toNativeConverter instanceof ToNativeConverter.PostInvocation) {
                mv.dup();
                converted[i] = localVariableAllocator.allocate(Object.class);
                mv.astore(converted[i]);
            }
            if (Number.class.isAssignableFrom(javaParameterClass)) {
                AsmUtil.unboxNumber(mv, javaParameterClass, nativeParameterClass);
                continue;
            }
            if (Boolean.class.isAssignableFrom(javaParameterClass)) {
                AsmUtil.unboxBoolean(mv, javaParameterClass, nativeParameterClass);
                continue;
            }
            if (Pointer.class.isAssignableFrom(javaParameterClass) && AsmUtil.isDelegate(parameterTypes[i].getDeclaredType())) {
                AsmUtil.unboxPointer(mv, nativeParameterClass);
                continue;
            }
            if (Pointer.class.isAssignableFrom(javaParameterClass) || Struct.class.isAssignableFrom(javaParameterClass)) {
                if (pointerCount++ < 1) {
                    mv.pushInt(0);
                    mv.istore(objCount);
                }
                strategies[i] = localVariableAllocator.allocate(ObjectParameterStrategy.class);
                if (parameterTypes[i].toNativeConverter != null) {
                    pointers[i] = localVariableAllocator.allocate(Object.class);
                    mv.astore(pointers[i]);
                    mv.aload(pointers[i]);
                } else {
                    pointers[i] = parameters[i];
                }
                AbstractFastNumericMethodGenerator.emitPointerParameterStrategyLookup(mv, javaParameterClass, parameterTypes[i].annotations);
                mv.astore(strategies[i]);
                mv.aload(strategies[i]);
                mv.getfield(CodegenUtils.p(PointerParameterStrategy.class), "objectCount", CodegenUtils.ci(Integer.TYPE));
                mv.iload(objCount);
                mv.iadd();
                mv.istore(objCount);
                mv.aload(strategies[i]);
                mv.aload(pointers[i]);
                mv.invokevirtual(PointerParameterStrategy.class, "address", Long.TYPE, Object.class);
                NumberUtil.narrow(mv, Long.TYPE, nativeParameterClass);
                continue;
            }
            if (javaParameterClass.isPrimitive()) continue;
            throw new IllegalArgumentException("unsupported type " + javaParameterClass);
        }
        Label hasObjects = new Label();
        Label convertResult = new Label();
        if (pointerCount > 0) {
            mv.iload(objCount);
            mv.ifne(hasObjects);
        }
        mv.invokestatic(builder.getClassNamePath(), nativeMethodName, CodegenUtils.sig(nativeReturnType, nativeParameterTypes));
        Class unboxedResultType = AsmUtil.unboxedReturnType(resultType.effectiveJavaType());
        NumberUtil.convertPrimitive(mv, nativeReturnType, unboxedResultType);
        if (pointerCount > 0) {
            mv.label(convertResult);
        }
        BaseMethodGenerator.emitPostInvoke(builder, mv, parameterTypes, parameters, converted);
        BaseMethodGenerator.convertAndReturnResult(builder, mv, resultType, unboxedResultType);
        if (pointerCount > 0) {
            int i;
            mv.label(hasObjects);
            LocalVariable[] tmp = new LocalVariable[parameterTypes.length];
            for (i = parameterTypes.length - 1; i >= 0; --i) {
                tmp[i] = localVariableAllocator.allocate(Long.TYPE);
                if (Float.TYPE == nativeParameterTypes[i]) {
                    mv.invokestatic(Float.class, "floatToRawIntBits", Integer.TYPE, Float.TYPE);
                    mv.i2l();
                } else if (Double.TYPE == nativeParameterTypes[i]) {
                    mv.invokestatic(Double.class, "doubleToRawLongBits", Long.TYPE, Double.TYPE);
                } else {
                    NumberUtil.convertPrimitive(mv, nativeParameterTypes[i], Long.TYPE, parameterTypes[i].nativeType);
                }
                mv.lstore(tmp[i]);
            }
            mv.getstatic(CodegenUtils.p(AbstractAsmLibraryInterface.class), "ffi", CodegenUtils.ci(Invoker.class));
            mv.aload(0);
            mv.getfield(builder.getClassNamePath(), builder.getCallContextFieldName(function), CodegenUtils.ci(CallContext.class));
            mv.aload(0);
            mv.getfield(builder.getClassNamePath(), builder.getFunctionAddressFieldName(function), CodegenUtils.ci(Long.TYPE));
            mv.lload(tmp);
            mv.iload(objCount);
            for (i = 0; i < parameterTypes.length; ++i) {
                if (pointers[i] == null) continue;
                mv.aload(pointers[i]);
                mv.aload(strategies[i]);
                mv.aload(0);
                ObjectParameterInfo info = ObjectParameterInfo.create((int)i, (int)AsmUtil.getNativeArrayFlags(parameterTypes[i].annotations));
                mv.getfield(builder.getClassNamePath(), builder.getObjectParameterInfoName(info), CodegenUtils.ci(ObjectParameterInfo.class));
            }
            mv.invokevirtual(CodegenUtils.p(Invoker.class), AbstractFastNumericMethodGenerator.getObjectParameterMethodName(parameterTypes.length), AbstractFastNumericMethodGenerator.getObjectParameterMethodSignature(parameterTypes.length, pointerCount));
            if (Float.TYPE == nativeReturnType) {
                NumberUtil.narrow(mv, Long.TYPE, Integer.TYPE);
                mv.invokestatic(Float.class, "intBitsToFloat", Float.TYPE, Integer.TYPE);
            } else if (Double.TYPE == nativeReturnType) {
                mv.invokestatic(Double.class, "longBitsToDouble", Double.TYPE, Long.TYPE);
            } else if (Void.TYPE == nativeReturnType) {
                mv.pop2();
            }
            NumberUtil.convertPrimitive(mv, Long.TYPE, unboxedResultType, resultType.nativeType);
            mv.go_to(convertResult);
        }
        mv.visitMaxs(100, localVariableAllocator.getSpaceUsed());
        mv.visitEnd();
    }

    void attach(Class clazz) {
        this.compiler.attach(clazz);
    }

    private static boolean isSupportedObjectParameterType(ParameterType type) {
        return Pointer.class.isAssignableFrom(type.effectiveJavaType()) || Struct.class.isAssignableFrom(type.effectiveJavaType());
    }

    private static boolean isSupportedType(SigType type) {
        Class javaType = type.effectiveJavaType();
        return Boolean.class.isAssignableFrom(javaType) || Boolean.TYPE == javaType || Byte.class.isAssignableFrom(javaType) || Byte.TYPE == javaType || Short.class.isAssignableFrom(javaType) || Short.TYPE == javaType || Integer.class.isAssignableFrom(javaType) || Integer.TYPE == javaType || Long.class == javaType || Long.TYPE == javaType || Float.class == javaType || Float.TYPE == javaType || Double.class == javaType || Double.TYPE == javaType || NativeLong.class == javaType;
    }

    static boolean isSupportedResult(ResultType resultType) {
        return X86MethodGenerator.isSupportedType(resultType) || Void.TYPE == resultType.effectiveJavaType() || resultType.nativeType == NativeType.ADDRESS;
    }

    static final boolean isSupportedParameter(ParameterType parameterType) {
        return X86MethodGenerator.isSupportedType(parameterType) || X86MethodGenerator.isSupportedObjectParameterType(parameterType) || AsmUtil.isDelegate(parameterType);
    }

    static Class getNativeClass(NativeType nativeType) {
        switch (nativeType) {
            case SCHAR: 
            case UCHAR: 
            case SSHORT: 
            case USHORT: 
            case SINT: 
            case UINT: 
            case SLONG: 
            case ULONG: 
            case ADDRESS: 
            case SLONGLONG: 
            case ULONGLONG: {
                return NumberUtil.sizeof(nativeType) <= 4 ? Integer.TYPE : Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case VOID: {
                return Void.TYPE;
            }
        }
        throw new IllegalArgumentException("unsupported native type: " + (Object)((Object)nativeType));
    }
}

