/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class FullList<E>
implements List<E> {
    private static final int DEFAULT_CAPACITY = 64;
    private final E blankElement;
    private final ArrayList<E> list;
    private int capacity;

    public static <F> FullListBuilder<F> builder() {
        return new FullListBuilder();
    }

    public static <F> FullList<F> newList(F ... elements) {
        FullList<Object> l = new FullList<Object>(null, 64);
        l.addAll(Arrays.asList(elements));
        return l;
    }

    public static <F> FullList<F> newListWithCapacity(int capacity) {
        return new FullList<Object>(null, capacity);
    }

    public static <F> FullList<F> newListWithCapacity(int capacity, F ... elements) {
        FullList<Object> l = new FullList<Object>(null, capacity);
        l.addAll(Arrays.asList(elements));
        return l;
    }

    private FullList(E blankElement, int capacity) {
        this.blankElement = blankElement;
        this.capacity = capacity;
        this.list = new ArrayList(capacity);
    }

    @Override
    public boolean add(E e) {
        int sizeBefore = this.list.size();
        this.list.add(e);
        this.removeTrail();
        return this.list.size() != sizeBefore;
    }

    @Override
    public void add(int index, E element) {
        if (element != this.blankElement) {
            this.addMissingBlanks(index);
            this.list.add(index, element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int sizeBefore = this.list.size();
        this.list.addAll(c);
        this.removeTrail();
        return this.list.size() != sizeBefore;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int sizeBefore = this.list.size();
        this.addMissingBlanks(index);
        this.list.addAll(index, c);
        this.removeTrail();
        return this.list.size() != sizeBefore;
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object o) {
        return o == this.blankElement || this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        return this.list.equals(o);
    }

    @Override
    public E get(int index) {
        if (index >= this.list.size()) {
            return this.blankElement;
        }
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public int indexOf(Object o) {
        int index = this.list.indexOf(o);
        if (index == -1 && o == this.blankElement) {
            return this.list.size();
        }
        return index;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = this.list.lastIndexOf(o);
        if (index == -1 && o == this.blankElement) {
            return this.list.size();
        }
        return index;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public E remove(int index) {
        if (index >= this.list.size()) {
            return this.blankElement;
        }
        E e = this.list.remove(index);
        this.removeTrail();
        return e;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.list.remove(o);
        this.removeTrail();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.list.removeAll(c);
        this.removeTrail();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.list.retainAll(c);
        this.removeTrail();
        return result;
    }

    @Override
    public E set(int index, E element) {
        E result;
        int size = this.list.size();
        int lastIndex = size - 1;
        if (index > lastIndex) {
            result = this.blankElement;
            if (element != this.blankElement) {
                if (index > size) {
                    this.addMissingBlanks(index);
                }
                this.list.add(element);
            }
        } else if (index < lastIndex) {
            result = this.list.set(index, element);
        } else if (element == this.blankElement) {
            result = this.list.remove(size - 1);
            this.removeTrail();
        } else {
            result = this.list.set(index, element);
        }
        return result;
    }

    @Override
    public int size() {
        return Integer.MAX_VALUE;
    }

    public int usedSize() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public String toString() {
        return this.list.toString();
    }

    private void addMissingBlanks(int index) {
        int count = index - this.list.size();
        for (int i = 0; i < count; ++i) {
            this.list.add(this.blankElement);
        }
    }

    private void removeTrail() {
        int last = this.list.size() - 1;
        while (last >= 0 && this.list.get(last) == this.blankElement) {
            this.list.remove(last);
            last = this.list.size() - 1;
        }
    }

    public int capacity() {
        if (this.capacity < this.list.size()) {
            this.capacity = this.list.size();
        }
        return this.capacity;
    }

    public static class FullListBuilder<F> {
        private F blankElement = null;
        private int capacity = 64;

        FullListBuilder() {
        }

        public FullListBuilder<F> blankElement(F element) {
            this.blankElement = element;
            return this;
        }

        public FullList<F> build() {
            return new FullList(this.blankElement, this.capacity);
        }

        public FullListBuilder<F> capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }
    }
}

