/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.XMLEscaper;
import java.util.HashMap;
import java.util.Map;

public class FastOdsXMLEscaper
implements XMLEscaper {
    private static final int BUFFER_SIZE = 65536;
    private static final char[][] CHAR_SUBSTITUTES_IN_ATTRIBUTE;
    private static final char[][] CHAR_SUBSTITUTES_IN_CONTENT;
    private final Map<String, String> attrCacheMap = new HashMap<String, String>();
    private final Map<String, String> contentCacheMap = new HashMap<String, String>();
    private char[] buffer;

    public static FastOdsXMLEscaper create() {
        return new FastOdsXMLEscaper(65536);
    }

    public FastOdsXMLEscaper(int bufferSize) {
        this.buffer = new char[bufferSize];
    }

    @Override
    public String escapeXMLAttribute(String s) {
        if (s == null) {
            return null;
        }
        String cached = this.attrCacheMap.get(s);
        if (cached != null) {
            return cached;
        }
        String escaped = this.getEscapedString(s, CHAR_SUBSTITUTES_IN_ATTRIBUTE);
        this.attrCacheMap.put(s, escaped);
        return escaped;
    }

    private String getEscapedString(String s, char[][] charSubstitutes) {
        int sourceLength = s.length();
        int previousDestIndex = 0;
        int firstIdenticalCharInSourceIndex = 0;
        boolean oneSpecialChar = false;
        for (int sourceIndex = 0; sourceIndex < sourceLength; ++sourceIndex) {
            char[] toCopy;
            char c = s.charAt(sourceIndex);
            if (c > '>' || (toCopy = charSubstitutes[c]) == null) continue;
            oneSpecialChar = true;
            previousDestIndex = this.fillBufferAndGetPreviousDestIndex(s, previousDestIndex, firstIdenticalCharInSourceIndex, sourceIndex, toCopy);
            firstIdenticalCharInSourceIndex = sourceIndex + 1;
        }
        String s2 = oneSpecialChar ? this.getString(s, sourceLength, previousDestIndex, firstIdenticalCharInSourceIndex) : s;
        return s2;
    }

    private int fillBufferAndGetPreviousDestIndex(String s, int previousDestIndex, int firstIdenticalCharInSourceIndex, int firstDifferentCharInSourceIndex, char[] toCopy) {
        int tcl = toCopy.length;
        int identicalCount = firstDifferentCharInSourceIndex - firstIdenticalCharInSourceIndex;
        if (previousDestIndex + tcl + identicalCount >= this.buffer.length) {
            char[] newBuffer = new char[2 * this.buffer.length];
            System.arraycopy(this.buffer, 0, newBuffer, 0, previousDestIndex);
            this.buffer = newBuffer;
        }
        if (identicalCount > 0) {
            s.getChars(firstIdenticalCharInSourceIndex, firstDifferentCharInSourceIndex, this.buffer, previousDestIndex);
            previousDestIndex += identicalCount;
        }
        for (char c : toCopy) {
            this.buffer[previousDestIndex++] = c;
        }
        return previousDestIndex;
    }

    private String getString(String s, int sourceLength, int previousDestIndex, int firstIdenticalCharInSourceIndex) {
        int identicalCount = sourceLength - firstIdenticalCharInSourceIndex;
        if (previousDestIndex + identicalCount >= this.buffer.length) {
            char[] newBuffer = new char[2 * this.buffer.length];
            System.arraycopy(this.buffer, 0, newBuffer, 0, previousDestIndex);
            this.buffer = newBuffer;
        }
        if (identicalCount > 0) {
            s.getChars(firstIdenticalCharInSourceIndex, sourceLength, this.buffer, previousDestIndex);
            previousDestIndex += identicalCount;
        }
        return new String(this.buffer, 0, previousDestIndex);
    }

    @Override
    public String escapeXMLContent(String s) {
        if (s == null) {
            return null;
        }
        String cached = this.contentCacheMap.get(s);
        if (cached != null) {
            return cached;
        }
        String escaped = this.getEscapedString(s, CHAR_SUBSTITUTES_IN_CONTENT);
        this.contentCacheMap.put(s, escaped);
        return escaped;
    }

    static {
        char[] REPLACEMENT_CHAR = "\\uFFFD".toCharArray();
        CHAR_SUBSTITUTES_IN_ATTRIBUTE = new char[][]{REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, "&#x9;".toCharArray(), "&#xA;".toCharArray(), REPLACEMENT_CHAR, REPLACEMENT_CHAR, "&#xD;".toCharArray(), REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, null, null, "&quot;".toCharArray(), null, null, null, "&amp;".toCharArray(), "&apos;".toCharArray(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;".toCharArray(), null, "&gt;".toCharArray()};
        CHAR_SUBSTITUTES_IN_CONTENT = new char[][]{REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, null, null, REPLACEMENT_CHAR, REPLACEMENT_CHAR, null, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, REPLACEMENT_CHAR, null, null, null, null, null, null, "&amp;".toCharArray(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;".toCharArray(), null, "&gt;".toCharArray()};
    }
}

