/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.SimpleColor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ColorHelper {
    private static ColorHelper helper;
    private static final int X_FF = 255;
    private static final int X_F = 15;
    private final Map<String, Color> colorByHexValue = new HashMap<String, Color>();

    public static Color fromRGB(int red, int green, int blue) {
        if (helper == null) {
            helper = new ColorHelper();
        }
        return helper.getFromRGB(red, green, blue);
    }

    public static Color fromString(String hexValue) {
        if (helper == null) {
            helper = new ColorHelper();
        }
        return helper.getFromString(hexValue);
    }

    ColorHelper() {
        for (SimpleColor c : SimpleColor.values()) {
            this.colorByHexValue.put(c.hexValue(), c);
        }
    }

    public Color getFromRGB(int red, int green, int blue) {
        return this.getFromString("#" + this.toHexString(red) + this.toHexString(green) + this.toHexString(blue));
    }

    private String toHexString(int n) {
        if (n < 0) {
            return "00";
        }
        if (n > 255) {
            return "ff";
        }
        StringBuilder sbReturn = new StringBuilder();
        if (n <= 15) {
            sbReturn.append('0');
        }
        sbReturn.append(Integer.toHexString(n));
        return sbReturn.toString();
    }

    public Color getFromString(String hexValue) {
        final String hv = hexValue.toLowerCase(Locale.US);
        Color color = this.colorByHexValue.get(hv);
        if (color == null) {
            color = new Color(){

                @Override
                public String hexValue() {
                    return hv;
                }
            };
            this.colorByHexValue.put(hv, color);
        }
        return color;
    }
}

