/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.util;

import com.github.jferard.fastods.util.Length;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class AbsoluteLength
implements Length {
    private static final double CM_FACTOR = 10.0;
    private static final double INCH_FACTOR = 25.4;
    private static final double PT_FACTOR = 0.35277777777777775;
    private static final double PC_FACTOR = 4.2333333333333325;
    private final double mm;

    public static AbsoluteLength mm(double value) {
        return new AbsoluteLength(value);
    }

    public static AbsoluteLength cm(double value) {
        return new AbsoluteLength(value * 10.0);
    }

    public static AbsoluteLength in(double value) {
        return new AbsoluteLength(value * 25.4);
    }

    public static AbsoluteLength pt(double value) {
        return new AbsoluteLength(value * 0.35277777777777775);
    }

    public static AbsoluteLength pc(double value) {
        return new AbsoluteLength(value * 4.2333333333333325);
    }

    AbsoluteLength(double mm) {
        this.mm = mm;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbsoluteLength)) {
            return false;
        }
        AbsoluteLength other = (AbsoluteLength)o;
        return this.mm - other.mm < 1.0E-5 && other.mm - this.mm < 1.0E-5;
    }

    public int hashCode() {
        return Double.valueOf(this.mm).hashCode();
    }

    public String toString() {
        return new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.US)).format(this.mm) + "mm";
    }

    @Override
    public boolean isNotNull() {
        return this.mm <= -1.0E-5 || this.mm >= 1.0E-5;
    }
}

