/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.SimpleColor;
import com.github.jferard.fastods.TagParameters;
import com.github.jferard.fastods.style.FontFace;
import com.github.jferard.fastods.style.TextPropertiesBuilder;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;

public class TextProperties
implements TagParameters {
    private final Color fontColor;
    private final String fontName;
    private final String fontSize;
    private final String fontStyle;
    private final Color fontUnderlineColor;
    private final Underline fontUnderlineStyle;
    private final String fontWeight;

    public static TextPropertiesBuilder builder() {
        return new TextPropertiesBuilder();
    }

    TextProperties(Color fontColor, String fontName, String fontWeight, String fontStyle, String fontSize, Color fontUnderlineColor, Underline fontUnderlineStyle) {
        this.fontColor = fontColor;
        this.fontName = fontName;
        this.fontWeight = fontWeight;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize;
        this.fontUnderlineColor = fontUnderlineColor;
        this.fontUnderlineStyle = fontUnderlineStyle;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:text-properties");
        if (this.fontWeight != null) {
            util.appendEAttribute(appendable, "fo:font-weight", this.fontWeight);
            util.appendEAttribute(appendable, "style:font-weight-asian", this.fontWeight);
            util.appendEAttribute(appendable, "style:font-weight-complex", this.fontWeight);
        }
        if (this.fontStyle != null) {
            util.appendEAttribute(appendable, "fo:font-style", this.fontStyle);
            util.appendEAttribute(appendable, "style:font-style-asian", this.fontStyle);
            util.appendEAttribute(appendable, "style:font-style-complex", this.fontStyle);
        }
        if (this.fontColor != SimpleColor.NONE) {
            util.appendAttribute(appendable, (CharSequence)"fo:color", this.fontColor.hexValue());
        }
        if (this.fontName != null) {
            util.appendAttribute(appendable, (CharSequence)"style:font-name", this.fontName);
        }
        if (this.fontSize != null) {
            util.appendAttribute(appendable, (CharSequence)"fo:font-size", this.fontSize);
            util.appendAttribute(appendable, (CharSequence)"style:font-size-asian", this.fontSize);
            util.appendAttribute(appendable, (CharSequence)"style:font-size-complex", this.fontSize);
        }
        if (this.fontUnderlineStyle != null) {
            util.appendAttribute(appendable, (CharSequence)"style:text-underline-style", this.fontUnderlineStyle.attrValue);
            util.appendAttribute(appendable, (CharSequence)"style:text-underline-width", "auto");
            if (this.fontUnderlineColor != SimpleColor.NONE) {
                util.appendAttribute(appendable, (CharSequence)"style:text-underline-color", this.fontUnderlineColor.hexValue());
            } else {
                util.appendAttribute(appendable, (CharSequence)"style:text-underline-color", "font-color");
            }
        }
        appendable.append("/>");
    }

    public boolean isNotEmpty() {
        return this.fontUnderlineStyle != null || this.fontColor != SimpleColor.NONE || this.fontSize != null || this.fontStyle != null || this.fontUnderlineColor != SimpleColor.NONE || this.fontWeight != null || this.fontName != null;
    }

    public FontFace getFontFace() {
        if (this.fontName != null) {
            return new FontFace(this.fontName);
        }
        return null;
    }

    public static enum Underline {
        DASH("dash"),
        DOT_DASH("dot-dash"),
        DOT_DOT_DASH("dot-dot-dash"),
        DOTTED("dotted"),
        LONG_DASH("long-dash"),
        NONE("none"),
        SOLID("solid"),
        WAVE("wave");

        private final String attrValue;

        private Underline(String attrValue) {
            this.attrValue = attrValue;
        }
    }
}

