/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.style;

import com.github.jferard.fastods.Color;
import com.github.jferard.fastods.Footer;
import com.github.jferard.fastods.Header;
import com.github.jferard.fastods.PageSection;
import com.github.jferard.fastods.SimpleColor;
import com.github.jferard.fastods.odselement.OdsElements;
import com.github.jferard.fastods.style.AddableToOdsElements;
import com.github.jferard.fastods.style.Margins;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.util.Hidable;
import com.github.jferard.fastods.util.Length;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.Locale;

public class PageLayoutStyle
implements AddableToOdsElements,
Hidable {
    private final Color backgroundColor;
    private final Footer footer;
    private final Header header;
    private final Margins margins;
    private final String name;
    private final String numFormat;
    private final Length pageHeight;
    private final Length pageWidth;
    private final PageStyle.PrintOrientation printOrientation;
    private final PageStyle.WritingMode writingMode;
    private final int scaleTo;
    private final int scaleToPages;
    private final PageStyle.Centering centering;

    PageLayoutStyle(String name, Margins margins, Length pageWidth, Length pageHeight, String numFormat, Color backgroundColor, Header header, Footer footer, PageStyle.PrintOrientation printOrientation, PageStyle.WritingMode writingMode, int scaleTo, int scaleToPages, PageStyle.Centering centering) {
        this.name = name;
        this.margins = margins;
        this.pageWidth = pageWidth;
        this.pageHeight = pageHeight;
        this.numFormat = numFormat;
        this.backgroundColor = backgroundColor;
        this.footer = footer;
        this.header = header;
        this.printOrientation = printOrientation;
        this.writingMode = writingMode;
        this.scaleTo = scaleTo;
        this.scaleToPages = scaleToPages;
        this.centering = centering;
    }

    @Override
    public void addToElements(OdsElements odsElements) {
        odsElements.addPageLayoutStyle(this);
    }

    public void appendXMLToAutomaticStyle(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<style:page-layout");
        util.appendEAttribute(appendable, "style:name", this.name);
        appendable.append("><style:page-layout-properties");
        util.appendAttribute(appendable, (CharSequence)"fo:page-width", this.pageWidth.toString());
        util.appendAttribute(appendable, (CharSequence)"fo:page-height", this.pageHeight.toString());
        if (this.scaleTo != 100) {
            util.appendAttribute(appendable, (CharSequence)"style:scale-to", this.scaleTo + "%");
        }
        if (this.scaleToPages != 0) {
            util.appendAttribute(appendable, (CharSequence)"style:scale-to-pages", this.scaleToPages);
        }
        if (this.centering != PageStyle.Centering.NONE) {
            util.appendAttribute(appendable, (CharSequence)"style:table-centering", this.centering.toString().toLowerCase(Locale.US));
        }
        util.appendEAttribute(appendable, "style:num-format", this.numFormat);
        util.appendAttribute(appendable, (CharSequence)"style:writing-mode", this.writingMode.getAttrValue());
        util.appendAttribute(appendable, (CharSequence)"style:print-orientation", this.printOrientation.getAttrValue());
        this.appendBackgroundColor(util, appendable);
        this.margins.appendXMLContent(util, appendable);
        appendable.append("/>");
        PageSection.appendPageSectionStyleXMLToAutomaticStyle(this.header, util, appendable);
        PageSection.appendPageSectionStyleXMLToAutomaticStyle(this.footer, util, appendable);
        appendable.append("</style:page-layout>");
    }

    public String getName() {
        return this.name;
    }

    public PageStyle.WritingMode getWritingMode() {
        return this.writingMode;
    }

    private void appendBackgroundColor(XMLUtil util, Appendable appendable) throws IOException {
        if (this.backgroundColor != SimpleColor.NONE) {
            util.appendAttribute(appendable, (CharSequence)"fo:background-color", this.backgroundColor.hexValue());
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }
}

