/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement.config;

import com.github.jferard.fastods.odselement.config.ConfigBlock;
import com.github.jferard.fastods.odselement.config.ConfigItemCollection;
import com.github.jferard.fastods.util.XMLUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ConfigItemSet
implements ConfigItemCollection<ConfigBlock> {
    private final Map<String, ConfigBlock> blockByName;
    private final String name;

    public ConfigItemSet(String name) {
        this.name = name;
        this.blockByName = new HashMap<String, ConfigBlock>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void appendXMLContent(XMLUtil util, Appendable appendable) throws IOException {
        appendable.append("<config:config-item-set");
        util.appendEAttribute(appendable, "config:name", this.name);
        appendable.append(">");
        for (ConfigBlock block : this.blockByName.values()) {
            block.appendXMLContent(util, appendable);
        }
        appendable.append("</config:config-item-set>");
    }

    @Override
    public int size() {
        return this.blockByName.size();
    }

    @Override
    public boolean isEmpty() {
        return this.blockByName.isEmpty();
    }

    @Override
    public Iterator<ConfigBlock> iterator() {
        return this.blockByName.values().iterator();
    }

    public void add(ConfigBlock configBlock) {
        this.blockByName.put(configBlock.getName(), configBlock);
    }

    public boolean contains(String name) {
        return this.blockByName.containsKey(name);
    }

    public void removeByName(String name) {
        this.blockByName.remove(name);
    }

    public ConfigBlock getByName(String name) {
        return this.blockByName.get(name);
    }
}

