/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.FinalizeFlusher;
import com.github.jferard.fastods.ImmutableElementsFlusher;
import com.github.jferard.fastods.MetaAndStylesElementsFlusher;
import com.github.jferard.fastods.NamedOdsFileWriter;
import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.ContentElement;
import com.github.jferard.fastods.odselement.ManifestElement;
import com.github.jferard.fastods.odselement.MetaElement;
import com.github.jferard.fastods.odselement.MimetypeElement;
import com.github.jferard.fastods.odselement.SettingsElement;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.odselement.StylesElement;
import com.github.jferard.fastods.odselement.config.ConfigItem;
import com.github.jferard.fastods.odselement.config.ConfigItemMapEntry;
import com.github.jferard.fastods.style.MasterPageStyle;
import com.github.jferard.fastods.style.ObjectStyle;
import com.github.jferard.fastods.style.PageLayoutStyle;
import com.github.jferard.fastods.style.PageStyle;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.PositionUtil;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;

public class OdsElements {
    public static final String SC_SPLIT_NORMAL = "0";
    public static final String SC_SPLIT_FIX = "2";
    private static final String[] EMPTY_ELEMENT_NAMES = new String[]{"Thumbnails/", "Configurations2/accelerator/current.xml", "Configurations2/floater/", "Configurations2/images/Bitmaps/", "Configurations2/menubar/", "Configurations2/popupmenu/", "Configurations2/progressbar/", "Configurations2/statusbar/", "Configurations2/toolbar/"};
    private final ContentElement contentElement;
    private final Logger logger;
    private final ManifestElement manifestElement;
    private final MetaElement metaElement;
    private final MimetypeElement mimeTypeElement;
    private final SettingsElement settingsElement;
    private final StylesContainer stylesContainer;
    private final StylesElement stylesElement;
    private NamedOdsFileWriter observer;

    public static OdsElements create(PositionUtil positionUtil, XMLUtil xmlUtil, WriteUtil writeUtil, DataStyles format, boolean libreOfficeMode) {
        Logger logger = Logger.getLogger(OdsElements.class.getName());
        MimetypeElement mimetypeElement = new MimetypeElement();
        ManifestElement manifestElement = new ManifestElement();
        SettingsElement settingsElement = SettingsElement.create();
        MetaElement metaElement = new MetaElement();
        StylesContainer stylesContainer = new StylesContainer(logger);
        StylesElement stylesElement = new StylesElement(stylesContainer);
        ContentElement contentElement = new ContentElement(positionUtil, xmlUtil, writeUtil, format, libreOfficeMode, stylesContainer);
        return new OdsElements(logger, stylesContainer, mimetypeElement, manifestElement, settingsElement, metaElement, contentElement, stylesElement);
    }

    OdsElements(Logger logger, StylesContainer stylesContainer, MimetypeElement mimeTypeElement, ManifestElement manifestElement, SettingsElement settingsElement, MetaElement metaElement, ContentElement contentElement, StylesElement stylesElement) {
        this.logger = logger;
        this.mimeTypeElement = mimeTypeElement;
        this.manifestElement = manifestElement;
        this.settingsElement = settingsElement;
        this.metaElement = metaElement;
        this.contentElement = contentElement;
        this.stylesElement = stylesElement;
        this.stylesContainer = stylesContainer;
    }

    public void addChildCellStyle(TableCellStyle style, TableCell.Type type) {
        this.contentElement.addChildCellStyle(style, type);
    }

    public void addDataStyle(DataStyle dataStyle) {
        this.stylesContainer.addDataStyle(dataStyle);
    }

    public void addMasterPageStyle(MasterPageStyle masterPageStyle) {
        this.stylesContainer.addMasterPageStyle(masterPageStyle);
    }

    public void addObserver(NamedOdsFileWriter o) {
        this.observer = o;
    }

    public void addPageLayoutStyle(PageLayoutStyle pageLayoutStyle) {
        this.stylesContainer.addPageLayoutStyle(pageLayoutStyle);
    }

    public void addPageStyle(PageStyle ps) {
        this.stylesContainer.addPageStyle(ps);
    }

    public void addContentStyle(ObjectStyle objectStyle) {
        this.stylesContainer.addContentStyle(objectStyle);
    }

    public void addStyleStyle(ObjectStyle objectStyle) {
        this.stylesContainer.addStylesStyle(objectStyle);
    }

    public void addStyleToContentAutomaticStyles(ObjectStyle objectStyle) {
        this.stylesContainer.addContentStyle(objectStyle);
    }

    public Table addTableToContent(String name, int rowCapacity, int columnCapacity) throws IOException {
        Table previousTable = this.contentElement.getLastTable();
        Table table = this.contentElement.addTable(name, rowCapacity, columnCapacity);
        this.settingsElement.addTableConfig(table.getConfigEntry());
        if (this.observer != null) {
            if (previousTable == null) {
                this.observer.update(new MetaAndStylesElementsFlusher(this, this.contentElement));
            } else {
                previousTable.flush();
            }
            table.addObserver(this.observer);
        }
        return table;
    }

    public void freezeCells(Table table, int rowCount, int colCount) {
        ConfigItemMapEntry tableConfig = table.getConfigEntry();
        tableConfig.put(new ConfigItem("HorizontalSplitMode", "short", SC_SPLIT_FIX));
        tableConfig.put(new ConfigItem("VerticalSplitMode", "short", SC_SPLIT_FIX));
        tableConfig.put(new ConfigItem("HorizontalSplitPosition", "int", String.valueOf(rowCount)));
        tableConfig.put(new ConfigItem("VerticalSplitPosition", "int", String.valueOf(colCount)));
    }

    public void createEmptyElements(ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing empty ods elements to zip file");
        for (String elementName : EMPTY_ELEMENT_NAMES) {
            this.logger.log(Level.FINEST, "Writing ods element: {0} to zip file", elementName);
            writer.putNextEntry(new ZipEntry(elementName));
            writer.closeEntry();
        }
    }

    public void debugStyles() {
        this.stylesContainer.debug();
    }

    public void finalizeContent(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.contentElement.flushTables(xmlUtil, writer, this.settingsElement);
        this.contentElement.writePostamble(xmlUtil, writer);
    }

    public void flushRows(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        this.contentElement.flushRows(util, writer, this.settingsElement);
    }

    public void flushTables(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        this.contentElement.flushTables(util, writer, this.settingsElement);
    }

    public void freezeStyles() {
        this.stylesContainer.freeze();
    }

    public Table getTable(int tableIndex) {
        return this.contentElement.getTable(tableIndex);
    }

    public Table getTable(String name) {
        return this.contentElement.getTable(name);
    }

    public int getTableCount() {
        return this.contentElement.getTableCount();
    }

    public List<Table> getTables() {
        return this.contentElement.getTables();
    }

    public void prepare() throws IOException {
        this.observer.update(new ImmutableElementsFlusher(this));
    }

    public void save() throws IOException {
        Table previousTable = this.contentElement.getLastTable();
        if (previousTable != null) {
            previousTable.flush();
        }
        this.observer.update(new FinalizeFlusher(this.contentElement, this.settingsElement));
    }

    public void setActiveTable(Table table) {
        this.settingsElement.setActiveTable(table);
    }

    public void setViewSetting(String viewId, String item, String value) {
        this.settingsElement.setViewSetting(viewId, item, value);
    }

    public void writeContent(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: contentElement to zip file");
        this.contentElement.write(xmlUtil, writer);
    }

    public void writeImmutableElements(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: mimeTypeEntry to zip file");
        this.mimeTypeElement.write(xmlUtil, writer);
        this.logger.log(Level.FINER, "Writing ods element: manifestElement to zip file");
        this.manifestElement.write(xmlUtil, writer);
    }

    public void writeMeta(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: metaElement to zip file");
        this.metaElement.write(xmlUtil, writer);
    }

    public void writeSettings(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.settingsElement.setTables(this.getTables());
        this.logger.log(Level.FINER, "Writing ods element: settingsElement to zip file");
        this.settingsElement.write(xmlUtil, writer);
    }

    public void writeStyles(XMLUtil xmlUtil, ZipUTF8Writer writer) throws IOException {
        this.logger.log(Level.FINER, "Writing ods element: stylesElement to zip file");
        this.stylesElement.write(xmlUtil, writer);
    }

    public void addAutoFilter(Table table, int r1, int c1, int r2, int c2) {
        table.addAutoFilter(r1, c1, r2, c2);
    }
}

