/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;

public class MetaElement
implements OdsElement {
    static final SimpleDateFormat DF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    static final SimpleDateFormat DF_TIME = new SimpleDateFormat("HH:mm:ss");
    private final String editingCycles;
    private final String editingDuration;
    private final String generator;
    private String creator;
    private String dateTime;

    public MetaElement() {
        this.setDateTimeNow();
        this.generator = "FastOds 0.5.0 2017";
        this.creator = "FastOds 0.5.0";
        this.editingCycles = "1";
        this.editingDuration = "PT1M00S";
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new ZipEntry("meta.xml"));
        writer.append("<?xml");
        util.appendAttribute((Appendable)writer, (CharSequence)"version", "1.0");
        util.appendAttribute((Appendable)writer, (CharSequence)"encoding", "UTF-8");
        writer.append("?><office:document-meta");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:xlink", "http://www.w3.org/1999/xlink");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:dc", "http://purl.org/dc/elements/1.1/");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");
        util.appendAttribute((Appendable)writer, (CharSequence)"xmlns:ooo", "http://openoffice.org/2004/office");
        util.appendAttribute((Appendable)writer, (CharSequence)"office:version", "1.2");
        writer.append("><office:meta>");
        util.appendTag(writer, "meta:generator", this.generator);
        util.appendTag(writer, "dc:creator", this.creator);
        util.appendTag(writer, "dc:date", this.dateTime);
        util.appendTag(writer, "meta:editing-cycles", this.editingCycles);
        util.appendTag(writer, "meta:editing-duration", this.editingDuration);
        writer.append("<meta:user-defined meta:name=\"Info 1\"/>").append("<meta:user-defined meta:name=\"Info 2\"/>").append("<meta:user-defined meta:name=\"Info 3\"/>").append("<meta:user-defined meta:name=\"Info 4\"/>");
        writer.append("</office:meta>").append("</office:document-meta>");
        writer.flush();
        writer.closeEntry();
    }

    private void setDateTimeNow() {
        Date dt = new Date();
        this.dateTime = DF_DATE.format(dt) + "T" + DF_TIME.format(dt);
    }
}

