/*
 * Decompiled with CFR 0.152.
 */
package com.github.jferard.fastods.odselement;

import com.github.jferard.fastods.Table;
import com.github.jferard.fastods.TableCell;
import com.github.jferard.fastods.datastyle.DataStyle;
import com.github.jferard.fastods.datastyle.DataStyles;
import com.github.jferard.fastods.odselement.FlushPosition;
import com.github.jferard.fastods.odselement.OdsElement;
import com.github.jferard.fastods.odselement.SettingsElement;
import com.github.jferard.fastods.odselement.StylesContainer;
import com.github.jferard.fastods.style.TableCellStyle;
import com.github.jferard.fastods.util.PositionUtil;
import com.github.jferard.fastods.util.UniqueList;
import com.github.jferard.fastods.util.WriteUtil;
import com.github.jferard.fastods.util.XMLUtil;
import com.github.jferard.fastods.util.ZipUTF8Writer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;

public class ContentElement
implements OdsElement {
    private final FlushPosition flushPosition;
    private final DataStyles format;
    private final PositionUtil positionUtil;
    private final StylesContainer stylesContainer;
    private final UniqueList<Table> tables;
    private final WriteUtil writeUtil;
    private final XMLUtil xmlUtil;
    private final boolean libreOfficeMode;
    private List<String> autoFilters;

    ContentElement(PositionUtil positionUtil, XMLUtil xmlUtil, WriteUtil writeUtil, DataStyles format, boolean libreOfficeMode, StylesContainer stylesContainer) {
        this.writeUtil = writeUtil;
        this.xmlUtil = xmlUtil;
        this.positionUtil = positionUtil;
        this.format = format;
        this.libreOfficeMode = libreOfficeMode;
        this.stylesContainer = stylesContainer;
        this.tables = new UniqueList();
        this.flushPosition = new FlushPosition();
    }

    public TableCellStyle addChildCellStyle(TableCellStyle style, TableCell.Type type) {
        DataStyle dataStyle = this.format.getDataStyle(type);
        TableCellStyle newStyle = dataStyle == null ? style : this.stylesContainer.addChildCellStyle(style, dataStyle);
        return newStyle;
    }

    public Table addTable(String name, int rowCapacity, int columnCapacity) {
        Table table = this.tables.getByName(name);
        if (table == null) {
            table = Table.create(this, this.positionUtil, this.writeUtil, this.xmlUtil, name, rowCapacity, columnCapacity, this.stylesContainer, this.format, this.libreOfficeMode);
            this.tables.add(table);
        }
        return table;
    }

    private void ensureContentBegin(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        if (this.flushPosition.isUndefined()) {
            this.writePreamble(util, writer);
            this.flushPosition.set(0, -1);
        }
    }

    public void flushRows(XMLUtil util, ZipUTF8Writer writer, SettingsElement settingsElement) throws IOException {
        Table lastTable;
        this.ensureContentBegin(util, writer);
        int lastTableIndex = this.tables.size() - 1;
        if (lastTableIndex == -1) {
            return;
        }
        int curTableIndex = this.flushPosition.getTableIndex();
        if (curTableIndex < lastTableIndex) {
            this.flushPendingTablesAndLastTableAvailableRows(util, writer, settingsElement, lastTableIndex, curTableIndex);
        } else {
            lastTable = (Table)this.tables.get(lastTableIndex);
            int firstRowIndex = this.flushPosition.getLastRowIndex() + 1;
            lastTable.flushSomeAvailableRowsFrom(util, writer, firstRowIndex);
        }
        lastTable = (Table)this.tables.get(lastTableIndex);
        this.flushPosition.set(lastTableIndex, lastTable.getRowCount() - 1);
    }

    private void flushPendingTablesAndLastTableAvailableRows(XMLUtil util, ZipUTF8Writer writer, SettingsElement settingsElement, int lastTableIndex, int curTableIndex) throws IOException {
        Table lastTable = (Table)this.tables.get(lastTableIndex);
        this.flushRemainingRowsFromCurTable(util, writer, settingsElement, curTableIndex);
        this.flushCompleteTables(util, writer, settingsElement, lastTableIndex, curTableIndex);
        lastTable.flushAllAvailableRows(util, writer);
    }

    private void flushRemainingRowsFromCurTable(XMLUtil util, ZipUTF8Writer writer, SettingsElement settingsElement, int curTableIndex) throws IOException {
        int firstRowIndex = this.flushPosition.getLastRowIndex() + 1;
        Table curTable = (Table)this.tables.get(curTableIndex);
        curTable.flushRemainingRowsFrom(util, writer, firstRowIndex);
        settingsElement.addTableConfig(curTable.getConfigEntry());
    }

    private void flushCompleteTables(XMLUtil util, ZipUTF8Writer writer, SettingsElement settingsElement, int from, int to) throws IOException {
        for (int index = to + 1; index < from; ++index) {
            Table table = (Table)this.tables.get(index);
            table.appendXMLToContentEntry(util, writer);
            settingsElement.addTableConfig(table.getConfigEntry());
        }
    }

    public void flushTables(XMLUtil util, ZipUTF8Writer writer, SettingsElement settingsElement) throws IOException {
        this.ensureContentBegin(util, writer);
        int lastTableIndex = this.tables.size() - 1;
        if (lastTableIndex < 0) {
            return;
        }
        int curTableIndex = this.flushPosition.getTableIndex();
        this.flushCompleteTables(util, writer, settingsElement, curTableIndex, lastTableIndex + 1);
    }

    public Table getLastTable() {
        int size = this.tables.size();
        return size <= 0 ? null : (Table)this.tables.get(size - 1);
    }

    public StylesContainer getStyleTagsContainer() {
        return this.stylesContainer;
    }

    public Table getTable(int tableIndex) {
        return (Table)this.tables.get(tableIndex);
    }

    public Table getTable(String name) {
        return this.tables.getByName(name);
    }

    public int getTableCount() {
        return this.tables.size();
    }

    public List<Table> getTables() {
        return this.tables;
    }

    @Override
    public void write(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        this.writePreamble(util, writer);
        for (Table table : this.tables) {
            table.appendXMLToContentEntry(util, writer);
        }
        this.writePostamble(util, writer);
    }

    public void writePostamble(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        if (this.autoFilters != null) {
            this.appendAutoFilters(writer, util);
        }
        writer.write("</office:spreadsheet>");
        writer.write("</office:body>");
        writer.write("</office:document-content>");
        writer.flush();
        writer.closeEntry();
    }

    public void writePreamble(XMLUtil util, ZipUTF8Writer writer) throws IOException {
        writer.putNextEntry(new ZipEntry("content.xml"));
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("<office:document-content xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\" xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:draw=\"urn:oasis:names:tc:opendocument:xmlns:drawing:1.0\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:meta=\"urn:oasis:names:tc:opendocument:xmlns:meta:1.0\" xmlns:number=\"urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0\" xmlns:presentation=\"urn:oasis:names:tc:opendocument:xmlns:presentation:1.0\" xmlns:svg=\"urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0\" xmlns:chart=\"urn:oasis:names:tc:opendocument:xmlns:chart:1.0\" xmlns:dr3d=\"urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0\" xmlns:math=\"http://www.w3.org/1998/Math/MathML\" xmlns:form=\"urn:oasis:names:tc:opendocument:xmlns:form:1.0\" xmlns:script=\"urn:oasis:names:tc:opendocument:xmlns:script:1.0\" xmlns:ooo=\"http://openoffice.org/2004/office\" xmlns:ooow=\"http://openoffice.org/2004/writer\" xmlns:oooc=\"http://openoffice.org/2004/calc\" xmlns:dom=\"http://www.w3.org/2001/xml-events\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" office:version=\"1.2\">");
        writer.write("<office:scripts/>");
        this.stylesContainer.writeFontFaceDecls(util, writer);
        writer.write("<office:automatic-styles>");
        this.stylesContainer.writeHiddenDataStyles(util, writer);
        this.stylesContainer.writeContentAutomaticStyles(util, writer);
        writer.write("</office:automatic-styles>");
        writer.write("<office:body>");
        writer.write("<office:spreadsheet>");
    }

    private void appendAutoFilters(Appendable appendable, XMLUtil util) throws IOException {
        appendable.append("<table:database-ranges>");
        for (String autoFilter : this.autoFilters) {
            appendable.append("<table:database-range");
            util.appendAttribute(appendable, (CharSequence)"table:display-filter-buttons", "true");
            util.appendAttribute(appendable, (CharSequence)"table:target-range-address", autoFilter);
            appendable.append("/>");
        }
        appendable.append("</table:database-ranges>");
    }

    public void addAutoFilter(Table table, int r1, int c1, int r2, int c2) {
        if (this.autoFilters == null) {
            this.autoFilters = new ArrayList<String>();
        }
        this.autoFilters.add(this.positionUtil.toRangeAddress(table, r1, c1, r2, c2));
    }
}

